/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceProperties.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceProperties extends com.google.api.client.json.GenericJson {

  /**
   * Controls for advanced machine-related behavior features. Note that for MachineImage, this is
   * not supported yet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AdvancedMachineFeatures advancedMachineFeatures;

  /**
   * Enables instances created based on these properties to send packets with source IP addresses
   * other than their own and receive packets with destination IP addresses other than their own. If
   * these instances will be used as an IP gateway or it will be set as the next-hop in a Route
   * resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding
   * documentation for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canIpForward;

  /**
   * Specifies the Confidential Instance options. Note that for MachineImage, this is not supported
   * yet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ConfidentialInstanceConfig confidentialInstanceConfig;

  /**
   * An optional text description for the instances that are created from these properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * An array of disks that are associated with the instances that are created from these
   * properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AttachedDisk> disks;

  static {
    // hack to force ProGuard to consider AttachedDisk used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AttachedDisk.class);
  }

  /**
   * A list of guest accelerator cards' type and count to use for instances created from these
   * properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AcceleratorConfig> guestAccelerators;

  static {
    // hack to force ProGuard to consider AcceleratorConfig used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AcceleratorConfig.class);
  }

  /**
   * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default
   * value is "NONE" if it is not specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String keyRevocationActionType;

  /**
   * Labels to apply to instances that are created from these properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * The machine type to use for instances that are created from these properties. This field only
   * accept machine types name. e.g. n2-standard-4 and does not accept machine type full or partial
   * url. e.g. projects/my-l7ilb-project/zones/us-central1-a/machineTypes/n2-standard-4 will throw
   * INTERNAL_ERROR.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String machineType;

  /**
   * The metadata key/value pairs to assign to instances that are created from these properties.
   * These pairs can consist of custom metadata or predefined keys. See Project and instance
   * metadata for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Metadata metadata;

  /**
   * Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or
   * newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as
   * minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information,
   * read Specifying a Minimum CPU Platform.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String minCpuPlatform;

  /**
   * An array of network access configurations for this interface.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<NetworkInterface> networkInterfaces;

  /**
   * Note that for MachineImage, this is not supported yet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NetworkPerformanceConfig networkPerformanceConfig;

  /**
   * The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as
   * default. Note that for MachineImage, this is not supported yet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String privateIpv6GoogleAccess;

  /**
   * Specifies the reservations that instances can consume from. Note that for MachineImage, this is
   * not supported yet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReservationAffinity reservationAffinity;

  /**
   * Resource manager tags to be bound to the instance. Tag keys and values have the same definition
   * as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in
   * the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> resourceManagerTags;

  /**
   * Resource policies (names, not URLs) applied to instances created from these properties. Note
   * that for MachineImage, this is not supported yet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> resourcePolicies;

  /**
   * Specifies the scheduling options for the instances that are created from these properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Scheduling scheduling;

  /**
   * A list of service accounts with specified scopes. Access tokens for these service accounts are
   * available to the instances that are created from these properties. Use metadata queries to
   * obtain the access tokens for these instances.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ServiceAccount> serviceAccounts;

  /**
   * Note that for MachineImage, this is not supported yet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ShieldedInstanceConfig shieldedInstanceConfig;

  /**
   * A list of tags to apply to the instances that are created from these properties. The tags
   * identify valid sources or targets for network firewalls. The setTags method can modify this
   * list of tags. Each tag within the list must comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Tags tags;

  /**
   * Controls for advanced machine-related behavior features. Note that for MachineImage, this is
   * not supported yet.
   * @return value or {@code null} for none
   */
  public AdvancedMachineFeatures getAdvancedMachineFeatures() {
    return advancedMachineFeatures;
  }

  /**
   * Controls for advanced machine-related behavior features. Note that for MachineImage, this is
   * not supported yet.
   * @param advancedMachineFeatures advancedMachineFeatures or {@code null} for none
   */
  public InstanceProperties setAdvancedMachineFeatures(AdvancedMachineFeatures advancedMachineFeatures) {
    this.advancedMachineFeatures = advancedMachineFeatures;
    return this;
  }

  /**
   * Enables instances created based on these properties to send packets with source IP addresses
   * other than their own and receive packets with destination IP addresses other than their own. If
   * these instances will be used as an IP gateway or it will be set as the next-hop in a Route
   * resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding
   * documentation for more information.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanIpForward() {
    return canIpForward;
  }

  /**
   * Enables instances created based on these properties to send packets with source IP addresses
   * other than their own and receive packets with destination IP addresses other than their own. If
   * these instances will be used as an IP gateway or it will be set as the next-hop in a Route
   * resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding
   * documentation for more information.
   * @param canIpForward canIpForward or {@code null} for none
   */
  public InstanceProperties setCanIpForward(java.lang.Boolean canIpForward) {
    this.canIpForward = canIpForward;
    return this;
  }

  /**
   * Specifies the Confidential Instance options. Note that for MachineImage, this is not supported
   * yet.
   * @return value or {@code null} for none
   */
  public ConfidentialInstanceConfig getConfidentialInstanceConfig() {
    return confidentialInstanceConfig;
  }

  /**
   * Specifies the Confidential Instance options. Note that for MachineImage, this is not supported
   * yet.
   * @param confidentialInstanceConfig confidentialInstanceConfig or {@code null} for none
   */
  public InstanceProperties setConfidentialInstanceConfig(ConfidentialInstanceConfig confidentialInstanceConfig) {
    this.confidentialInstanceConfig = confidentialInstanceConfig;
    return this;
  }

  /**
   * An optional text description for the instances that are created from these properties.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional text description for the instances that are created from these properties.
   * @param description description or {@code null} for none
   */
  public InstanceProperties setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * An array of disks that are associated with the instances that are created from these
   * properties.
   * @return value or {@code null} for none
   */
  public java.util.List<AttachedDisk> getDisks() {
    return disks;
  }

  /**
   * An array of disks that are associated with the instances that are created from these
   * properties.
   * @param disks disks or {@code null} for none
   */
  public InstanceProperties setDisks(java.util.List<AttachedDisk> disks) {
    this.disks = disks;
    return this;
  }

  /**
   * A list of guest accelerator cards' type and count to use for instances created from these
   * properties.
   * @return value or {@code null} for none
   */
  public java.util.List<AcceleratorConfig> getGuestAccelerators() {
    return guestAccelerators;
  }

  /**
   * A list of guest accelerator cards' type and count to use for instances created from these
   * properties.
   * @param guestAccelerators guestAccelerators or {@code null} for none
   */
  public InstanceProperties setGuestAccelerators(java.util.List<AcceleratorConfig> guestAccelerators) {
    this.guestAccelerators = guestAccelerators;
    return this;
  }

  /**
   * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default
   * value is "NONE" if it is not specified.
   * @return value or {@code null} for none
   */
  public java.lang.String getKeyRevocationActionType() {
    return keyRevocationActionType;
  }

  /**
   * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default
   * value is "NONE" if it is not specified.
   * @param keyRevocationActionType keyRevocationActionType or {@code null} for none
   */
  public InstanceProperties setKeyRevocationActionType(java.lang.String keyRevocationActionType) {
    this.keyRevocationActionType = keyRevocationActionType;
    return this;
  }

  /**
   * Labels to apply to instances that are created from these properties.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * Labels to apply to instances that are created from these properties.
   * @param labels labels or {@code null} for none
   */
  public InstanceProperties setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * The machine type to use for instances that are created from these properties. This field only
   * accept machine types name. e.g. n2-standard-4 and does not accept machine type full or partial
   * url. e.g. projects/my-l7ilb-project/zones/us-central1-a/machineTypes/n2-standard-4 will throw
   * INTERNAL_ERROR.
   * @return value or {@code null} for none
   */
  public java.lang.String getMachineType() {
    return machineType;
  }

  /**
   * The machine type to use for instances that are created from these properties. This field only
   * accept machine types name. e.g. n2-standard-4 and does not accept machine type full or partial
   * url. e.g. projects/my-l7ilb-project/zones/us-central1-a/machineTypes/n2-standard-4 will throw
   * INTERNAL_ERROR.
   * @param machineType machineType or {@code null} for none
   */
  public InstanceProperties setMachineType(java.lang.String machineType) {
    this.machineType = machineType;
    return this;
  }

  /**
   * The metadata key/value pairs to assign to instances that are created from these properties.
   * These pairs can consist of custom metadata or predefined keys. See Project and instance
   * metadata for more information.
   * @return value or {@code null} for none
   */
  public Metadata getMetadata() {
    return metadata;
  }

  /**
   * The metadata key/value pairs to assign to instances that are created from these properties.
   * These pairs can consist of custom metadata or predefined keys. See Project and instance
   * metadata for more information.
   * @param metadata metadata or {@code null} for none
   */
  public InstanceProperties setMetadata(Metadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or
   * newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as
   * minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information,
   * read Specifying a Minimum CPU Platform.
   * @return value or {@code null} for none
   */
  public java.lang.String getMinCpuPlatform() {
    return minCpuPlatform;
  }

  /**
   * Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or
   * newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as
   * minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information,
   * read Specifying a Minimum CPU Platform.
   * @param minCpuPlatform minCpuPlatform or {@code null} for none
   */
  public InstanceProperties setMinCpuPlatform(java.lang.String minCpuPlatform) {
    this.minCpuPlatform = minCpuPlatform;
    return this;
  }

  /**
   * An array of network access configurations for this interface.
   * @return value or {@code null} for none
   */
  public java.util.List<NetworkInterface> getNetworkInterfaces() {
    return networkInterfaces;
  }

  /**
   * An array of network access configurations for this interface.
   * @param networkInterfaces networkInterfaces or {@code null} for none
   */
  public InstanceProperties setNetworkInterfaces(java.util.List<NetworkInterface> networkInterfaces) {
    this.networkInterfaces = networkInterfaces;
    return this;
  }

  /**
   * Note that for MachineImage, this is not supported yet.
   * @return value or {@code null} for none
   */
  public NetworkPerformanceConfig getNetworkPerformanceConfig() {
    return networkPerformanceConfig;
  }

  /**
   * Note that for MachineImage, this is not supported yet.
   * @param networkPerformanceConfig networkPerformanceConfig or {@code null} for none
   */
  public InstanceProperties setNetworkPerformanceConfig(NetworkPerformanceConfig networkPerformanceConfig) {
    this.networkPerformanceConfig = networkPerformanceConfig;
    return this;
  }

  /**
   * The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as
   * default. Note that for MachineImage, this is not supported yet.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrivateIpv6GoogleAccess() {
    return privateIpv6GoogleAccess;
  }

  /**
   * The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as
   * default. Note that for MachineImage, this is not supported yet.
   * @param privateIpv6GoogleAccess privateIpv6GoogleAccess or {@code null} for none
   */
  public InstanceProperties setPrivateIpv6GoogleAccess(java.lang.String privateIpv6GoogleAccess) {
    this.privateIpv6GoogleAccess = privateIpv6GoogleAccess;
    return this;
  }

  /**
   * Specifies the reservations that instances can consume from. Note that for MachineImage, this is
   * not supported yet.
   * @return value or {@code null} for none
   */
  public ReservationAffinity getReservationAffinity() {
    return reservationAffinity;
  }

  /**
   * Specifies the reservations that instances can consume from. Note that for MachineImage, this is
   * not supported yet.
   * @param reservationAffinity reservationAffinity or {@code null} for none
   */
  public InstanceProperties setReservationAffinity(ReservationAffinity reservationAffinity) {
    this.reservationAffinity = reservationAffinity;
    return this;
  }

  /**
   * Resource manager tags to be bound to the instance. Tag keys and values have the same definition
   * as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in
   * the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getResourceManagerTags() {
    return resourceManagerTags;
  }

  /**
   * Resource manager tags to be bound to the instance. Tag keys and values have the same definition
   * as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in
   * the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.
   * @param resourceManagerTags resourceManagerTags or {@code null} for none
   */
  public InstanceProperties setResourceManagerTags(java.util.Map<String, java.lang.String> resourceManagerTags) {
    this.resourceManagerTags = resourceManagerTags;
    return this;
  }

  /**
   * Resource policies (names, not URLs) applied to instances created from these properties. Note
   * that for MachineImage, this is not supported yet.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getResourcePolicies() {
    return resourcePolicies;
  }

  /**
   * Resource policies (names, not URLs) applied to instances created from these properties. Note
   * that for MachineImage, this is not supported yet.
   * @param resourcePolicies resourcePolicies or {@code null} for none
   */
  public InstanceProperties setResourcePolicies(java.util.List<java.lang.String> resourcePolicies) {
    this.resourcePolicies = resourcePolicies;
    return this;
  }

  /**
   * Specifies the scheduling options for the instances that are created from these properties.
   * @return value or {@code null} for none
   */
  public Scheduling getScheduling() {
    return scheduling;
  }

  /**
   * Specifies the scheduling options for the instances that are created from these properties.
   * @param scheduling scheduling or {@code null} for none
   */
  public InstanceProperties setScheduling(Scheduling scheduling) {
    this.scheduling = scheduling;
    return this;
  }

  /**
   * A list of service accounts with specified scopes. Access tokens for these service accounts are
   * available to the instances that are created from these properties. Use metadata queries to
   * obtain the access tokens for these instances.
   * @return value or {@code null} for none
   */
  public java.util.List<ServiceAccount> getServiceAccounts() {
    return serviceAccounts;
  }

  /**
   * A list of service accounts with specified scopes. Access tokens for these service accounts are
   * available to the instances that are created from these properties. Use metadata queries to
   * obtain the access tokens for these instances.
   * @param serviceAccounts serviceAccounts or {@code null} for none
   */
  public InstanceProperties setServiceAccounts(java.util.List<ServiceAccount> serviceAccounts) {
    this.serviceAccounts = serviceAccounts;
    return this;
  }

  /**
   * Note that for MachineImage, this is not supported yet.
   * @return value or {@code null} for none
   */
  public ShieldedInstanceConfig getShieldedInstanceConfig() {
    return shieldedInstanceConfig;
  }

  /**
   * Note that for MachineImage, this is not supported yet.
   * @param shieldedInstanceConfig shieldedInstanceConfig or {@code null} for none
   */
  public InstanceProperties setShieldedInstanceConfig(ShieldedInstanceConfig shieldedInstanceConfig) {
    this.shieldedInstanceConfig = shieldedInstanceConfig;
    return this;
  }

  /**
   * A list of tags to apply to the instances that are created from these properties. The tags
   * identify valid sources or targets for network firewalls. The setTags method can modify this
   * list of tags. Each tag within the list must comply with RFC1035.
   * @return value or {@code null} for none
   */
  public Tags getTags() {
    return tags;
  }

  /**
   * A list of tags to apply to the instances that are created from these properties. The tags
   * identify valid sources or targets for network firewalls. The setTags method can modify this
   * list of tags. Each tag within the list must comply with RFC1035.
   * @param tags tags or {@code null} for none
   */
  public InstanceProperties setTags(Tags tags) {
    this.tags = tags;
    return this;
  }

  @Override
  public InstanceProperties set(String fieldName, Object value) {
    return (InstanceProperties) super.set(fieldName, value);
  }

  @Override
  public InstanceProperties clone() {
    return (InstanceProperties) super.clone();
  }

}
