/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for NodeGroupNode.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NodeGroupNode extends com.google.api.client.json.GenericJson {

  /**
   * Accelerators for this node.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AcceleratorConfig> accelerators;

  static {
    // hack to force ProGuard to consider AcceleratorConfig used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AcceleratorConfig.class);
  }

  /**
   * Node resources that are reserved by all instances.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstanceConsumptionInfo consumedResources;

  /**
   * CPU overcommit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cpuOvercommitType;

  /**
   * Local disk configurations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LocalDisk> disks;

  static {
    // hack to force ProGuard to consider LocalDisk used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(LocalDisk.class);
  }

  /**
   * Instance data that shows consumed resources on the node.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InstanceConsumptionData> instanceConsumptionData;

  static {
    // hack to force ProGuard to consider InstanceConsumptionData used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(InstanceConsumptionData.class);
  }

  /**
   * Instances scheduled on this node.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> instances;

  /**
   * The name of the node.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The type of this node.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nodeType;

  /**
   * [Output Only] Reserved for future use.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean satisfiesPzs;

  /**
   * Binding properties for the physical server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ServerBinding serverBinding;

  /**
   * Server ID associated with this node.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String serverId;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Total amount of available resources on the node.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstanceConsumptionInfo totalResources;

  /**
   * [Output Only] The information about an upcoming maintenance event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpcomingMaintenance upcomingMaintenance;

  /**
   * Accelerators for this node.
   * @return value or {@code null} for none
   */
  public java.util.List<AcceleratorConfig> getAccelerators() {
    return accelerators;
  }

  /**
   * Accelerators for this node.
   * @param accelerators accelerators or {@code null} for none
   */
  public NodeGroupNode setAccelerators(java.util.List<AcceleratorConfig> accelerators) {
    this.accelerators = accelerators;
    return this;
  }

  /**
   * Node resources that are reserved by all instances.
   * @return value or {@code null} for none
   */
  public InstanceConsumptionInfo getConsumedResources() {
    return consumedResources;
  }

  /**
   * Node resources that are reserved by all instances.
   * @param consumedResources consumedResources or {@code null} for none
   */
  public NodeGroupNode setConsumedResources(InstanceConsumptionInfo consumedResources) {
    this.consumedResources = consumedResources;
    return this;
  }

  /**
   * CPU overcommit.
   * @return value or {@code null} for none
   */
  public java.lang.String getCpuOvercommitType() {
    return cpuOvercommitType;
  }

  /**
   * CPU overcommit.
   * @param cpuOvercommitType cpuOvercommitType or {@code null} for none
   */
  public NodeGroupNode setCpuOvercommitType(java.lang.String cpuOvercommitType) {
    this.cpuOvercommitType = cpuOvercommitType;
    return this;
  }

  /**
   * Local disk configurations.
   * @return value or {@code null} for none
   */
  public java.util.List<LocalDisk> getDisks() {
    return disks;
  }

  /**
   * Local disk configurations.
   * @param disks disks or {@code null} for none
   */
  public NodeGroupNode setDisks(java.util.List<LocalDisk> disks) {
    this.disks = disks;
    return this;
  }

  /**
   * Instance data that shows consumed resources on the node.
   * @return value or {@code null} for none
   */
  public java.util.List<InstanceConsumptionData> getInstanceConsumptionData() {
    return instanceConsumptionData;
  }

  /**
   * Instance data that shows consumed resources on the node.
   * @param instanceConsumptionData instanceConsumptionData or {@code null} for none
   */
  public NodeGroupNode setInstanceConsumptionData(java.util.List<InstanceConsumptionData> instanceConsumptionData) {
    this.instanceConsumptionData = instanceConsumptionData;
    return this;
  }

  /**
   * Instances scheduled on this node.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getInstances() {
    return instances;
  }

  /**
   * Instances scheduled on this node.
   * @param instances instances or {@code null} for none
   */
  public NodeGroupNode setInstances(java.util.List<java.lang.String> instances) {
    this.instances = instances;
    return this;
  }

  /**
   * The name of the node.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the node.
   * @param name name or {@code null} for none
   */
  public NodeGroupNode setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The type of this node.
   * @return value or {@code null} for none
   */
  public java.lang.String getNodeType() {
    return nodeType;
  }

  /**
   * The type of this node.
   * @param nodeType nodeType or {@code null} for none
   */
  public NodeGroupNode setNodeType(java.lang.String nodeType) {
    this.nodeType = nodeType;
    return this;
  }

  /**
   * [Output Only] Reserved for future use.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSatisfiesPzs() {
    return satisfiesPzs;
  }

  /**
   * [Output Only] Reserved for future use.
   * @param satisfiesPzs satisfiesPzs or {@code null} for none
   */
  public NodeGroupNode setSatisfiesPzs(java.lang.Boolean satisfiesPzs) {
    this.satisfiesPzs = satisfiesPzs;
    return this;
  }

  /**
   * Binding properties for the physical server.
   * @return value or {@code null} for none
   */
  public ServerBinding getServerBinding() {
    return serverBinding;
  }

  /**
   * Binding properties for the physical server.
   * @param serverBinding serverBinding or {@code null} for none
   */
  public NodeGroupNode setServerBinding(ServerBinding serverBinding) {
    this.serverBinding = serverBinding;
    return this;
  }

  /**
   * Server ID associated with this node.
   * @return value or {@code null} for none
   */
  public java.lang.String getServerId() {
    return serverId;
  }

  /**
   * Server ID associated with this node.
   * @param serverId serverId or {@code null} for none
   */
  public NodeGroupNode setServerId(java.lang.String serverId) {
    this.serverId = serverId;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * @param status status or {@code null} for none
   */
  public NodeGroupNode setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * Total amount of available resources on the node.
   * @return value or {@code null} for none
   */
  public InstanceConsumptionInfo getTotalResources() {
    return totalResources;
  }

  /**
   * Total amount of available resources on the node.
   * @param totalResources totalResources or {@code null} for none
   */
  public NodeGroupNode setTotalResources(InstanceConsumptionInfo totalResources) {
    this.totalResources = totalResources;
    return this;
  }

  /**
   * [Output Only] The information about an upcoming maintenance event.
   * @return value or {@code null} for none
   */
  public UpcomingMaintenance getUpcomingMaintenance() {
    return upcomingMaintenance;
  }

  /**
   * [Output Only] The information about an upcoming maintenance event.
   * @param upcomingMaintenance upcomingMaintenance or {@code null} for none
   */
  public NodeGroupNode setUpcomingMaintenance(UpcomingMaintenance upcomingMaintenance) {
    this.upcomingMaintenance = upcomingMaintenance;
    return this;
  }

  @Override
  public NodeGroupNode set(String fieldName, Object value) {
    return (NodeGroupNode) super.set(fieldName, value);
  }

  @Override
  public NodeGroupNode clone() {
    return (NodeGroupNode) super.clone();
  }

}
