/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InterconnectDiagnosticsLinkOpticalPower.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectDiagnosticsLinkOpticalPower extends com.google.api.client.json.GenericJson {

  /**
   * The status of the current value when compared to the warning and alarm levels for the receiving
   * or transmitting transceiver. Possible states include: - OK: The value has not crossed a warning
   * threshold. - LOW_WARNING: The value has crossed below the low warning threshold. -
   * HIGH_WARNING: The value has crossed above the high warning threshold. - LOW_ALARM: The value
   * has crossed below the low alarm threshold. - HIGH_ALARM: The value has crossed above the high
   * alarm threshold.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Value of the current receiving or transmitting optical power, read in dBm. Take a known good
   * optical value, give it a 10% margin and trigger warnings relative to that value. In general, a
   * -7dBm warning and a -11dBm alarm are good optical value estimates for most links.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float value;

  /**
   * The status of the current value when compared to the warning and alarm levels for the receiving
   * or transmitting transceiver. Possible states include: - OK: The value has not crossed a warning
   * threshold. - LOW_WARNING: The value has crossed below the low warning threshold. -
   * HIGH_WARNING: The value has crossed above the high warning threshold. - LOW_ALARM: The value
   * has crossed below the low alarm threshold. - HIGH_ALARM: The value has crossed above the high
   * alarm threshold.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * The status of the current value when compared to the warning and alarm levels for the receiving
   * or transmitting transceiver. Possible states include: - OK: The value has not crossed a warning
   * threshold. - LOW_WARNING: The value has crossed below the low warning threshold. -
   * HIGH_WARNING: The value has crossed above the high warning threshold. - LOW_ALARM: The value
   * has crossed below the low alarm threshold. - HIGH_ALARM: The value has crossed above the high
   * alarm threshold.
   * @param state state or {@code null} for none
   */
  public InterconnectDiagnosticsLinkOpticalPower setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * Value of the current receiving or transmitting optical power, read in dBm. Take a known good
   * optical value, give it a 10% margin and trigger warnings relative to that value. In general, a
   * -7dBm warning and a -11dBm alarm are good optical value estimates for most links.
   * @return value or {@code null} for none
   */
  public java.lang.Float getValue() {
    return value;
  }

  /**
   * Value of the current receiving or transmitting optical power, read in dBm. Take a known good
   * optical value, give it a 10% margin and trigger warnings relative to that value. In general, a
   * -7dBm warning and a -11dBm alarm are good optical value estimates for most links.
   * @param value value or {@code null} for none
   */
  public InterconnectDiagnosticsLinkOpticalPower setValue(java.lang.Float value) {
    this.value = value;
    return this;
  }

  @Override
  public InterconnectDiagnosticsLinkOpticalPower set(String fieldName, Object value) {
    return (InterconnectDiagnosticsLinkOpticalPower) super.set(fieldName, value);
  }

  @Override
  public InterconnectDiagnosticsLinkOpticalPower clone() {
    return (InterconnectDiagnosticsLinkOpticalPower) super.clone();
  }

}
