/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a Instance Settings resource. You can use instance settings to configure default
 * settings for Compute Engine VM instances. For example, you can use it to configure default
 * machine type of Compute Engine VM instances.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceSettings extends com.google.api.client.json.GenericJson {

  /**
   * Specifies a fingerprint for instance settings, which is essentially a hash of the instance
   * settings resource's contents and used for optimistic locking. The fingerprint is initially
   * generated by Compute Engine and changes after every request to modify or update the instance
   * settings resource. You must always provide an up-to-date fingerprint hash in order to update or
   * change the resource, otherwise the request will fail with error 412 conditionNotMet. To see the
   * latest fingerprint, make a get() request to retrieve the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fingerprint;

  /**
   * [Output Only] Type of the resource. Always compute#instance_settings for instance settings.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The metadata key/value pairs assigned to all the instances in the corresponding scope.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstanceSettingsMetadata metadata;

  /**
   * [Output Only] URL of the zone where the resource resides You must specify this field as part of
   * the HTTP request URL. It is not settable as a field in the request body.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * Specifies a fingerprint for instance settings, which is essentially a hash of the instance
   * settings resource's contents and used for optimistic locking. The fingerprint is initially
   * generated by Compute Engine and changes after every request to modify or update the instance
   * settings resource. You must always provide an up-to-date fingerprint hash in order to update or
   * change the resource, otherwise the request will fail with error 412 conditionNotMet. To see the
   * latest fingerprint, make a get() request to retrieve the resource.
   * @see #decodeFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getFingerprint() {
    return fingerprint;
  }

  /**
   * Specifies a fingerprint for instance settings, which is essentially a hash of the instance
   * settings resource's contents and used for optimistic locking. The fingerprint is initially
   * generated by Compute Engine and changes after every request to modify or update the instance
   * settings resource. You must always provide an up-to-date fingerprint hash in order to update or
   * change the resource, otherwise the request will fail with error 412 conditionNotMet. To see the
   * latest fingerprint, make a get() request to retrieve the resource.
   * @see #getFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(fingerprint);
  }

  /**
   * Specifies a fingerprint for instance settings, which is essentially a hash of the instance
   * settings resource's contents and used for optimistic locking. The fingerprint is initially
   * generated by Compute Engine and changes after every request to modify or update the instance
   * settings resource. You must always provide an up-to-date fingerprint hash in order to update or
   * change the resource, otherwise the request will fail with error 412 conditionNotMet. To see the
   * latest fingerprint, make a get() request to retrieve the resource.
   * @see #encodeFingerprint()
   * @param fingerprint fingerprint or {@code null} for none
   */
  public InstanceSettings setFingerprint(java.lang.String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * Specifies a fingerprint for instance settings, which is essentially a hash of the instance
   * settings resource's contents and used for optimistic locking. The fingerprint is initially
   * generated by Compute Engine and changes after every request to modify or update the instance
   * settings resource. You must always provide an up-to-date fingerprint hash in order to update or
   * change the resource, otherwise the request will fail with error 412 conditionNotMet. To see the
   * latest fingerprint, make a get() request to retrieve the resource.
   * @see #setFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public InstanceSettings encodeFingerprint(byte[] fingerprint) {
    this.fingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(fingerprint);
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#instance_settings for instance settings.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#instance_settings for instance settings.
   * @param kind kind or {@code null} for none
   */
  public InstanceSettings setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The metadata key/value pairs assigned to all the instances in the corresponding scope.
   * @return value or {@code null} for none
   */
  public InstanceSettingsMetadata getMetadata() {
    return metadata;
  }

  /**
   * The metadata key/value pairs assigned to all the instances in the corresponding scope.
   * @param metadata metadata or {@code null} for none
   */
  public InstanceSettings setMetadata(InstanceSettingsMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * [Output Only] URL of the zone where the resource resides You must specify this field as part of
   * the HTTP request URL. It is not settable as a field in the request body.
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * [Output Only] URL of the zone where the resource resides You must specify this field as part of
   * the HTTP request URL. It is not settable as a field in the request body.
   * @param zone zone or {@code null} for none
   */
  public InstanceSettings setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public InstanceSettings set(String fieldName, Object value) {
    return (InstanceSettings) super.set(fieldName, value);
  }

  @Override
  public InstanceSettings clone() {
    return (InstanceSettings) super.clone();
  }

}
