/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The HTTP cookie used for stateful session affinity.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BackendServiceHttpCookie extends com.google.api.client.json.GenericJson {

  /**
   * Name of the cookie.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Path to set for the cookie.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String path;

  /**
   * Lifetime of the cookie.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Duration ttl;

  /**
   * Name of the cookie.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the cookie.
   * @param name name or {@code null} for none
   */
  public BackendServiceHttpCookie setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Path to set for the cookie.
   * @return value or {@code null} for none
   */
  public java.lang.String getPath() {
    return path;
  }

  /**
   * Path to set for the cookie.
   * @param path path or {@code null} for none
   */
  public BackendServiceHttpCookie setPath(java.lang.String path) {
    this.path = path;
    return this;
  }

  /**
   * Lifetime of the cookie.
   * @return value or {@code null} for none
   */
  public Duration getTtl() {
    return ttl;
  }

  /**
   * Lifetime of the cookie.
   * @param ttl ttl or {@code null} for none
   */
  public BackendServiceHttpCookie setTtl(Duration ttl) {
    this.ttl = ttl;
    return this;
  }

  @Override
  public BackendServiceHttpCookie set(String fieldName, Object value) {
    return (BackendServiceHttpCookie) super.set(fieldName, value);
  }

  @Override
  public BackendServiceHttpCookie clone() {
    return (BackendServiceHttpCookie) super.clone();
  }

}
