/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a Target HTTPS Proxy resource. Google Compute Engine has two Target HTTPS Proxy
 * resources: * [Global](/compute/docs/reference/rest/v1/targetHttpsProxies) *
 * [Regional](/compute/docs/reference/rest/v1/regionTargetHttpsProxies) A target HTTPS proxy is a
 * component of GCP HTTPS load balancers. * targetHttpProxies are used by global external
 * Application Load Balancers, classic Application Load Balancers, cross-region internal Application
 * Load Balancers, and Traffic Director. * regionTargetHttpProxies are used by regional internal
 * Application Load Balancers and regional external Application Load Balancers. Forwarding rules
 * reference a target HTTPS proxy, and the target proxy then references a URL map. For more
 * information, read Using Target Proxies and Forwarding rule concepts.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TargetHttpsProxy extends com.google.api.client.json.GenericJson {

  /**
   * Optional. A URL referring to a networksecurity.AuthorizationPolicy resource that describes how
   * the proxy should authorize inbound traffic. If left blank, access will not be restricted by an
   * authorization policy. Refer to the AuthorizationPolicy resource for additional details.
   * authorizationPolicy only applies to a global TargetHttpsProxy attached to globalForwardingRules
   * with the loadBalancingScheme set to INTERNAL_SELF_MANAGED. Note: This field currently has no
   * impact.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String authorizationPolicy;

  /**
   * URL of a certificate map that identifies a certificate map associated with the given target
   * proxy. This field can only be set for Global external Application Load Balancer or Classic
   * Application Load Balancer. For other products use Certificate Manager Certificates instead. If
   * set, sslCertificates will be ignored. Accepted format is
   * //certificatemanager.googleapis.com/projects/{project
   * }/locations/{location}/certificateMaps/{resourceName}.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String certificateMap;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a TargetHttpsProxy. An up-to-
   * date fingerprint must be provided in order to patch the TargetHttpsProxy; otherwise, the
   * request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get()
   * request to retrieve the TargetHttpsProxy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fingerprint;

  /**
   * Specifies how long to keep a connection open, after completing a response, while there is no
   * matching traffic (in seconds). If an HTTP keep-alive is not specified, a default value (610
   * seconds) will be used. For global external Application Load Balancers, the minimum allowed
   * value is 5 seconds and the maximum allowed value is 1200 seconds. For classic Application Load
   * Balancers, this option is not supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer httpKeepAliveTimeoutSec;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] Type of resource. Always compute#targetHttpsProxy for target HTTPS proxies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * This field only applies when the forwarding rule that references this target proxy has a
   * loadBalancingScheme set to INTERNAL_SELF_MANAGED. When this field is set to true, Envoy proxies
   * set up inbound traffic interception and bind to the IP address and port specified in the
   * forwarding rule. This is generally useful when using Traffic Director to configure Envoy as a
   * gateway or middle proxy (in other words, not a sidecar proxy). The Envoy proxy listens for
   * inbound requests and handles requests when it receives them. The default is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean proxyBind;

  /**
   * Specifies the QUIC override policy for this TargetHttpsProxy resource. This setting determines
   * whether the load balancer attempts to negotiate QUIC with clients. You can specify NONE,
   * ENABLE, or DISABLE. - When quic-override is set to NONE, Google manages whether QUIC is used. -
   * When quic-override is set to ENABLE, the load balancer uses QUIC when possible. - When quic-
   * override is set to DISABLE, the load balancer doesn't use QUIC. - If the quic-override flag is
   * not specified, NONE is implied.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String quicOverride;

  /**
   * [Output Only] URL of the region where the regional TargetHttpsProxy resides. This field is not
   * applicable to global TargetHttpsProxies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Optional. A URL referring to a networksecurity.ServerTlsPolicy resource that describes how the
   * proxy should authenticate inbound traffic. serverTlsPolicy only applies to a global
   * TargetHttpsProxy attached to globalForwardingRules with the loadBalancingScheme set to
   * INTERNAL_SELF_MANAGED or EXTERNAL or EXTERNAL_MANAGED. For details which ServerTlsPolicy
   * resources are accepted with INTERNAL_SELF_MANAGED and which with EXTERNAL, EXTERNAL_MANAGED
   * loadBalancingScheme consult ServerTlsPolicy documentation. If left blank, communications are
   * not encrypted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String serverTlsPolicy;

  /**
   * URLs to SslCertificate resources that are used to authenticate connections between users and
   * the load balancer. At least one SSL certificate must be specified. SslCertificates do not apply
   * when the load balancing scheme is set to INTERNAL_SELF_MANAGED. The URLs should refer to a SSL
   * Certificate resource or Certificate Manager Certificate resource. Mixing Classic Certificates
   * and Certificate Manager Certificates is not allowed. Certificate Manager Certificates must
   * include the certificatemanager API. Certificate Manager Certificates are not supported by
   * Global external Application Load Balancer or Classic Application Load Balancer, use
   * certificate_map instead. Currently, you may specify up to 15 Classic SSL Certificates.
   * Certificate Manager Certificates accepted formats are: -
   * //certificatemanager.googleapis.com/projects/{project}/locations/{
   * location}/certificates/{resourceName}. -
   * https://certificatemanager.googleapis.com/v1alpha1/projects/{project
   * }/locations/{location}/certificates/{resourceName}.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> sslCertificates;

  /**
   * URL of SslPolicy resource that will be associated with the TargetHttpsProxy resource. If not
   * set, the TargetHttpsProxy resource has no SSL policy configured.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sslPolicy;

  /**
   * Specifies whether TLS 1.3 0-RTT Data ("Early Data") should be accepted for this service. Early
   * Data allows a TLS resumption handshake to include the initial application payload (a HTTP
   * request) alongside the handshake, reducing the effective round trips to "zero". This applies to
   * TLS 1.3 connections over TCP (HTTP/2) as well as over UDP (QUIC/h3). This can improve
   * application performance, especially on networks where interruptions may be common, such as on
   * mobile. Requests with Early Data will have the "Early-Data" HTTP header set on the request,
   * with a value of "1", to allow the backend to determine whether Early Data was included. Note:
   * TLS Early Data may allow requests to be replayed, as the data is sent to the backend before the
   * handshake has fully completed. Applications that allow idempotent HTTP methods to make non-
   * idempotent changes, such as a GET request updating a database, should not accept Early Data on
   * those requests, and reject requests with the "Early-Data: 1" HTTP header by returning a HTTP
   * 425 (Too Early) status code, in order to remain RFC compliant. The default value is DISABLED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tlsEarlyData;

  /**
   * A fully-qualified or valid partial URL to the UrlMap resource that defines the mapping from URL
   * to the BackendService. For example, the following are all valid URLs for specifying a URL map:
   * - https://www.googleapis.compute/v1/projects/project/global/urlMaps/ url-map -
   * projects/project/global/urlMaps/url-map - global/urlMaps/url-map
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String urlMap;

  /**
   * Optional. A URL referring to a networksecurity.AuthorizationPolicy resource that describes how
   * the proxy should authorize inbound traffic. If left blank, access will not be restricted by an
   * authorization policy. Refer to the AuthorizationPolicy resource for additional details.
   * authorizationPolicy only applies to a global TargetHttpsProxy attached to globalForwardingRules
   * with the loadBalancingScheme set to INTERNAL_SELF_MANAGED. Note: This field currently has no
   * impact.
   * @return value or {@code null} for none
   */
  public java.lang.String getAuthorizationPolicy() {
    return authorizationPolicy;
  }

  /**
   * Optional. A URL referring to a networksecurity.AuthorizationPolicy resource that describes how
   * the proxy should authorize inbound traffic. If left blank, access will not be restricted by an
   * authorization policy. Refer to the AuthorizationPolicy resource for additional details.
   * authorizationPolicy only applies to a global TargetHttpsProxy attached to globalForwardingRules
   * with the loadBalancingScheme set to INTERNAL_SELF_MANAGED. Note: This field currently has no
   * impact.
   * @param authorizationPolicy authorizationPolicy or {@code null} for none
   */
  public TargetHttpsProxy setAuthorizationPolicy(java.lang.String authorizationPolicy) {
    this.authorizationPolicy = authorizationPolicy;
    return this;
  }

  /**
   * URL of a certificate map that identifies a certificate map associated with the given target
   * proxy. This field can only be set for Global external Application Load Balancer or Classic
   * Application Load Balancer. For other products use Certificate Manager Certificates instead. If
   * set, sslCertificates will be ignored. Accepted format is
   * //certificatemanager.googleapis.com/projects/{project
   * }/locations/{location}/certificateMaps/{resourceName}.
   * @return value or {@code null} for none
   */
  public java.lang.String getCertificateMap() {
    return certificateMap;
  }

  /**
   * URL of a certificate map that identifies a certificate map associated with the given target
   * proxy. This field can only be set for Global external Application Load Balancer or Classic
   * Application Load Balancer. For other products use Certificate Manager Certificates instead. If
   * set, sslCertificates will be ignored. Accepted format is
   * //certificatemanager.googleapis.com/projects/{project
   * }/locations/{location}/certificateMaps/{resourceName}.
   * @param certificateMap certificateMap or {@code null} for none
   */
  public TargetHttpsProxy setCertificateMap(java.lang.String certificateMap) {
    this.certificateMap = certificateMap;
    return this;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public TargetHttpsProxy setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public TargetHttpsProxy setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a TargetHttpsProxy. An up-to-
   * date fingerprint must be provided in order to patch the TargetHttpsProxy; otherwise, the
   * request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get()
   * request to retrieve the TargetHttpsProxy.
   * @see #decodeFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getFingerprint() {
    return fingerprint;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a TargetHttpsProxy. An up-to-
   * date fingerprint must be provided in order to patch the TargetHttpsProxy; otherwise, the
   * request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get()
   * request to retrieve the TargetHttpsProxy.
   * @see #getFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(fingerprint);
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a TargetHttpsProxy. An up-to-
   * date fingerprint must be provided in order to patch the TargetHttpsProxy; otherwise, the
   * request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get()
   * request to retrieve the TargetHttpsProxy.
   * @see #encodeFingerprint()
   * @param fingerprint fingerprint or {@code null} for none
   */
  public TargetHttpsProxy setFingerprint(java.lang.String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a TargetHttpsProxy. An up-to-
   * date fingerprint must be provided in order to patch the TargetHttpsProxy; otherwise, the
   * request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get()
   * request to retrieve the TargetHttpsProxy.
   * @see #setFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public TargetHttpsProxy encodeFingerprint(byte[] fingerprint) {
    this.fingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(fingerprint);
    return this;
  }

  /**
   * Specifies how long to keep a connection open, after completing a response, while there is no
   * matching traffic (in seconds). If an HTTP keep-alive is not specified, a default value (610
   * seconds) will be used. For global external Application Load Balancers, the minimum allowed
   * value is 5 seconds and the maximum allowed value is 1200 seconds. For classic Application Load
   * Balancers, this option is not supported.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getHttpKeepAliveTimeoutSec() {
    return httpKeepAliveTimeoutSec;
  }

  /**
   * Specifies how long to keep a connection open, after completing a response, while there is no
   * matching traffic (in seconds). If an HTTP keep-alive is not specified, a default value (610
   * seconds) will be used. For global external Application Load Balancers, the minimum allowed
   * value is 5 seconds and the maximum allowed value is 1200 seconds. For classic Application Load
   * Balancers, this option is not supported.
   * @param httpKeepAliveTimeoutSec httpKeepAliveTimeoutSec or {@code null} for none
   */
  public TargetHttpsProxy setHttpKeepAliveTimeoutSec(java.lang.Integer httpKeepAliveTimeoutSec) {
    this.httpKeepAliveTimeoutSec = httpKeepAliveTimeoutSec;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public TargetHttpsProxy setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] Type of resource. Always compute#targetHttpsProxy for target HTTPS proxies.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of resource. Always compute#targetHttpsProxy for target HTTPS proxies.
   * @param kind kind or {@code null} for none
   */
  public TargetHttpsProxy setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public TargetHttpsProxy setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * This field only applies when the forwarding rule that references this target proxy has a
   * loadBalancingScheme set to INTERNAL_SELF_MANAGED. When this field is set to true, Envoy proxies
   * set up inbound traffic interception and bind to the IP address and port specified in the
   * forwarding rule. This is generally useful when using Traffic Director to configure Envoy as a
   * gateway or middle proxy (in other words, not a sidecar proxy). The Envoy proxy listens for
   * inbound requests and handles requests when it receives them. The default is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getProxyBind() {
    return proxyBind;
  }

  /**
   * This field only applies when the forwarding rule that references this target proxy has a
   * loadBalancingScheme set to INTERNAL_SELF_MANAGED. When this field is set to true, Envoy proxies
   * set up inbound traffic interception and bind to the IP address and port specified in the
   * forwarding rule. This is generally useful when using Traffic Director to configure Envoy as a
   * gateway or middle proxy (in other words, not a sidecar proxy). The Envoy proxy listens for
   * inbound requests and handles requests when it receives them. The default is false.
   * @param proxyBind proxyBind or {@code null} for none
   */
  public TargetHttpsProxy setProxyBind(java.lang.Boolean proxyBind) {
    this.proxyBind = proxyBind;
    return this;
  }

  /**
   * Specifies the QUIC override policy for this TargetHttpsProxy resource. This setting determines
   * whether the load balancer attempts to negotiate QUIC with clients. You can specify NONE,
   * ENABLE, or DISABLE. - When quic-override is set to NONE, Google manages whether QUIC is used. -
   * When quic-override is set to ENABLE, the load balancer uses QUIC when possible. - When quic-
   * override is set to DISABLE, the load balancer doesn't use QUIC. - If the quic-override flag is
   * not specified, NONE is implied.
   * @return value or {@code null} for none
   */
  public java.lang.String getQuicOverride() {
    return quicOverride;
  }

  /**
   * Specifies the QUIC override policy for this TargetHttpsProxy resource. This setting determines
   * whether the load balancer attempts to negotiate QUIC with clients. You can specify NONE,
   * ENABLE, or DISABLE. - When quic-override is set to NONE, Google manages whether QUIC is used. -
   * When quic-override is set to ENABLE, the load balancer uses QUIC when possible. - When quic-
   * override is set to DISABLE, the load balancer doesn't use QUIC. - If the quic-override flag is
   * not specified, NONE is implied.
   * @param quicOverride quicOverride or {@code null} for none
   */
  public TargetHttpsProxy setQuicOverride(java.lang.String quicOverride) {
    this.quicOverride = quicOverride;
    return this;
  }

  /**
   * [Output Only] URL of the region where the regional TargetHttpsProxy resides. This field is not
   * applicable to global TargetHttpsProxies.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * [Output Only] URL of the region where the regional TargetHttpsProxy resides. This field is not
   * applicable to global TargetHttpsProxies.
   * @param region region or {@code null} for none
   */
  public TargetHttpsProxy setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public TargetHttpsProxy setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Optional. A URL referring to a networksecurity.ServerTlsPolicy resource that describes how the
   * proxy should authenticate inbound traffic. serverTlsPolicy only applies to a global
   * TargetHttpsProxy attached to globalForwardingRules with the loadBalancingScheme set to
   * INTERNAL_SELF_MANAGED or EXTERNAL or EXTERNAL_MANAGED. For details which ServerTlsPolicy
   * resources are accepted with INTERNAL_SELF_MANAGED and which with EXTERNAL, EXTERNAL_MANAGED
   * loadBalancingScheme consult ServerTlsPolicy documentation. If left blank, communications are
   * not encrypted.
   * @return value or {@code null} for none
   */
  public java.lang.String getServerTlsPolicy() {
    return serverTlsPolicy;
  }

  /**
   * Optional. A URL referring to a networksecurity.ServerTlsPolicy resource that describes how the
   * proxy should authenticate inbound traffic. serverTlsPolicy only applies to a global
   * TargetHttpsProxy attached to globalForwardingRules with the loadBalancingScheme set to
   * INTERNAL_SELF_MANAGED or EXTERNAL or EXTERNAL_MANAGED. For details which ServerTlsPolicy
   * resources are accepted with INTERNAL_SELF_MANAGED and which with EXTERNAL, EXTERNAL_MANAGED
   * loadBalancingScheme consult ServerTlsPolicy documentation. If left blank, communications are
   * not encrypted.
   * @param serverTlsPolicy serverTlsPolicy or {@code null} for none
   */
  public TargetHttpsProxy setServerTlsPolicy(java.lang.String serverTlsPolicy) {
    this.serverTlsPolicy = serverTlsPolicy;
    return this;
  }

  /**
   * URLs to SslCertificate resources that are used to authenticate connections between users and
   * the load balancer. At least one SSL certificate must be specified. SslCertificates do not apply
   * when the load balancing scheme is set to INTERNAL_SELF_MANAGED. The URLs should refer to a SSL
   * Certificate resource or Certificate Manager Certificate resource. Mixing Classic Certificates
   * and Certificate Manager Certificates is not allowed. Certificate Manager Certificates must
   * include the certificatemanager API. Certificate Manager Certificates are not supported by
   * Global external Application Load Balancer or Classic Application Load Balancer, use
   * certificate_map instead. Currently, you may specify up to 15 Classic SSL Certificates.
   * Certificate Manager Certificates accepted formats are: -
   * //certificatemanager.googleapis.com/projects/{project}/locations/{
   * location}/certificates/{resourceName}. -
   * https://certificatemanager.googleapis.com/v1alpha1/projects/{project
   * }/locations/{location}/certificates/{resourceName}.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSslCertificates() {
    return sslCertificates;
  }

  /**
   * URLs to SslCertificate resources that are used to authenticate connections between users and
   * the load balancer. At least one SSL certificate must be specified. SslCertificates do not apply
   * when the load balancing scheme is set to INTERNAL_SELF_MANAGED. The URLs should refer to a SSL
   * Certificate resource or Certificate Manager Certificate resource. Mixing Classic Certificates
   * and Certificate Manager Certificates is not allowed. Certificate Manager Certificates must
   * include the certificatemanager API. Certificate Manager Certificates are not supported by
   * Global external Application Load Balancer or Classic Application Load Balancer, use
   * certificate_map instead. Currently, you may specify up to 15 Classic SSL Certificates.
   * Certificate Manager Certificates accepted formats are: -
   * //certificatemanager.googleapis.com/projects/{project}/locations/{
   * location}/certificates/{resourceName}. -
   * https://certificatemanager.googleapis.com/v1alpha1/projects/{project
   * }/locations/{location}/certificates/{resourceName}.
   * @param sslCertificates sslCertificates or {@code null} for none
   */
  public TargetHttpsProxy setSslCertificates(java.util.List<java.lang.String> sslCertificates) {
    this.sslCertificates = sslCertificates;
    return this;
  }

  /**
   * URL of SslPolicy resource that will be associated with the TargetHttpsProxy resource. If not
   * set, the TargetHttpsProxy resource has no SSL policy configured.
   * @return value or {@code null} for none
   */
  public java.lang.String getSslPolicy() {
    return sslPolicy;
  }

  /**
   * URL of SslPolicy resource that will be associated with the TargetHttpsProxy resource. If not
   * set, the TargetHttpsProxy resource has no SSL policy configured.
   * @param sslPolicy sslPolicy or {@code null} for none
   */
  public TargetHttpsProxy setSslPolicy(java.lang.String sslPolicy) {
    this.sslPolicy = sslPolicy;
    return this;
  }

  /**
   * Specifies whether TLS 1.3 0-RTT Data ("Early Data") should be accepted for this service. Early
   * Data allows a TLS resumption handshake to include the initial application payload (a HTTP
   * request) alongside the handshake, reducing the effective round trips to "zero". This applies to
   * TLS 1.3 connections over TCP (HTTP/2) as well as over UDP (QUIC/h3). This can improve
   * application performance, especially on networks where interruptions may be common, such as on
   * mobile. Requests with Early Data will have the "Early-Data" HTTP header set on the request,
   * with a value of "1", to allow the backend to determine whether Early Data was included. Note:
   * TLS Early Data may allow requests to be replayed, as the data is sent to the backend before the
   * handshake has fully completed. Applications that allow idempotent HTTP methods to make non-
   * idempotent changes, such as a GET request updating a database, should not accept Early Data on
   * those requests, and reject requests with the "Early-Data: 1" HTTP header by returning a HTTP
   * 425 (Too Early) status code, in order to remain RFC compliant. The default value is DISABLED.
   * @return value or {@code null} for none
   */
  public java.lang.String getTlsEarlyData() {
    return tlsEarlyData;
  }

  /**
   * Specifies whether TLS 1.3 0-RTT Data ("Early Data") should be accepted for this service. Early
   * Data allows a TLS resumption handshake to include the initial application payload (a HTTP
   * request) alongside the handshake, reducing the effective round trips to "zero". This applies to
   * TLS 1.3 connections over TCP (HTTP/2) as well as over UDP (QUIC/h3). This can improve
   * application performance, especially on networks where interruptions may be common, such as on
   * mobile. Requests with Early Data will have the "Early-Data" HTTP header set on the request,
   * with a value of "1", to allow the backend to determine whether Early Data was included. Note:
   * TLS Early Data may allow requests to be replayed, as the data is sent to the backend before the
   * handshake has fully completed. Applications that allow idempotent HTTP methods to make non-
   * idempotent changes, such as a GET request updating a database, should not accept Early Data on
   * those requests, and reject requests with the "Early-Data: 1" HTTP header by returning a HTTP
   * 425 (Too Early) status code, in order to remain RFC compliant. The default value is DISABLED.
   * @param tlsEarlyData tlsEarlyData or {@code null} for none
   */
  public TargetHttpsProxy setTlsEarlyData(java.lang.String tlsEarlyData) {
    this.tlsEarlyData = tlsEarlyData;
    return this;
  }

  /**
   * A fully-qualified or valid partial URL to the UrlMap resource that defines the mapping from URL
   * to the BackendService. For example, the following are all valid URLs for specifying a URL map:
   * - https://www.googleapis.compute/v1/projects/project/global/urlMaps/ url-map -
   * projects/project/global/urlMaps/url-map - global/urlMaps/url-map
   * @return value or {@code null} for none
   */
  public java.lang.String getUrlMap() {
    return urlMap;
  }

  /**
   * A fully-qualified or valid partial URL to the UrlMap resource that defines the mapping from URL
   * to the BackendService. For example, the following are all valid URLs for specifying a URL map:
   * - https://www.googleapis.compute/v1/projects/project/global/urlMaps/ url-map -
   * projects/project/global/urlMaps/url-map - global/urlMaps/url-map
   * @param urlMap urlMap or {@code null} for none
   */
  public TargetHttpsProxy setUrlMap(java.lang.String urlMap) {
    this.urlMap = urlMap;
    return this;
  }

  @Override
  public TargetHttpsProxy set(String fieldName, Object value) {
    return (TargetHttpsProxy) super.set(fieldName, value);
  }

  @Override
  public TargetHttpsProxy clone() {
    return (TargetHttpsProxy) super.clone();
  }

}
