/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A set of Confidential Instance options.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ConfidentialInstanceConfig extends com.google.api.client.json.GenericJson {

  /**
   * Defines the type of technology used by the confidential instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String confidentialInstanceType;

  /**
   * Defines whether the instance should have confidential compute enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableConfidentialCompute;

  /**
   * Defines the type of technology used by the confidential instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getConfidentialInstanceType() {
    return confidentialInstanceType;
  }

  /**
   * Defines the type of technology used by the confidential instance.
   * @param confidentialInstanceType confidentialInstanceType or {@code null} for none
   */
  public ConfidentialInstanceConfig setConfidentialInstanceType(java.lang.String confidentialInstanceType) {
    this.confidentialInstanceType = confidentialInstanceType;
    return this;
  }

  /**
   * Defines whether the instance should have confidential compute enabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableConfidentialCompute() {
    return enableConfidentialCompute;
  }

  /**
   * Defines whether the instance should have confidential compute enabled.
   * @param enableConfidentialCompute enableConfidentialCompute or {@code null} for none
   */
  public ConfidentialInstanceConfig setEnableConfidentialCompute(java.lang.Boolean enableConfidentialCompute) {
    this.enableConfidentialCompute = enableConfidentialCompute;
    return this;
  }

  @Override
  public ConfidentialInstanceConfig set(String fieldName, Object value) {
    return (ConfidentialInstanceConfig) super.set(fieldName, value);
  }

  @Override
  public ConfidentialInstanceConfig clone() {
    return (ConfidentialInstanceConfig) super.clone();
  }

}
