/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for SecurityPolicyUserDefinedField.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SecurityPolicyUserDefinedField extends com.google.api.client.json.GenericJson {

  /**
   * The base relative to which 'offset' is measured. Possible values are: - IPV4: Points to the
   * beginning of the IPv4 header. - IPV6: Points to the beginning of the IPv6 header. - TCP: Points
   * to the beginning of the TCP header, skipping over any IPv4 options or IPv6 extension headers.
   * Not present for non-first fragments. - UDP: Points to the beginning of the UDP header, skipping
   * over any IPv4 options or IPv6 extension headers. Not present for non-first fragments. required
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String base;

  /**
   * If specified, apply this mask (bitwise AND) to the field to ignore bits before matching.
   * Encoded as a hexadecimal number (starting with "0x"). The last byte of the field (in network
   * byte order) corresponds to the least significant byte of the mask.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mask;

  /**
   * The name of this field. Must be unique within the policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Offset of the first byte of the field (in network byte order) relative to 'base'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer offset;

  /**
   * Size of the field in bytes. Valid values: 1-4.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer size;

  /**
   * The base relative to which 'offset' is measured. Possible values are: - IPV4: Points to the
   * beginning of the IPv4 header. - IPV6: Points to the beginning of the IPv6 header. - TCP: Points
   * to the beginning of the TCP header, skipping over any IPv4 options or IPv6 extension headers.
   * Not present for non-first fragments. - UDP: Points to the beginning of the UDP header, skipping
   * over any IPv4 options or IPv6 extension headers. Not present for non-first fragments. required
   * @return value or {@code null} for none
   */
  public java.lang.String getBase() {
    return base;
  }

  /**
   * The base relative to which 'offset' is measured. Possible values are: - IPV4: Points to the
   * beginning of the IPv4 header. - IPV6: Points to the beginning of the IPv6 header. - TCP: Points
   * to the beginning of the TCP header, skipping over any IPv4 options or IPv6 extension headers.
   * Not present for non-first fragments. - UDP: Points to the beginning of the UDP header, skipping
   * over any IPv4 options or IPv6 extension headers. Not present for non-first fragments. required
   * @param base base or {@code null} for none
   */
  public SecurityPolicyUserDefinedField setBase(java.lang.String base) {
    this.base = base;
    return this;
  }

  /**
   * If specified, apply this mask (bitwise AND) to the field to ignore bits before matching.
   * Encoded as a hexadecimal number (starting with "0x"). The last byte of the field (in network
   * byte order) corresponds to the least significant byte of the mask.
   * @return value or {@code null} for none
   */
  public java.lang.String getMask() {
    return mask;
  }

  /**
   * If specified, apply this mask (bitwise AND) to the field to ignore bits before matching.
   * Encoded as a hexadecimal number (starting with "0x"). The last byte of the field (in network
   * byte order) corresponds to the least significant byte of the mask.
   * @param mask mask or {@code null} for none
   */
  public SecurityPolicyUserDefinedField setMask(java.lang.String mask) {
    this.mask = mask;
    return this;
  }

  /**
   * The name of this field. Must be unique within the policy.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this field. Must be unique within the policy.
   * @param name name or {@code null} for none
   */
  public SecurityPolicyUserDefinedField setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Offset of the first byte of the field (in network byte order) relative to 'base'.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getOffset() {
    return offset;
  }

  /**
   * Offset of the first byte of the field (in network byte order) relative to 'base'.
   * @param offset offset or {@code null} for none
   */
  public SecurityPolicyUserDefinedField setOffset(java.lang.Integer offset) {
    this.offset = offset;
    return this;
  }

  /**
   * Size of the field in bytes. Valid values: 1-4.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSize() {
    return size;
  }

  /**
   * Size of the field in bytes. Valid values: 1-4.
   * @param size size or {@code null} for none
   */
  public SecurityPolicyUserDefinedField setSize(java.lang.Integer size) {
    this.size = size;
    return this;
  }

  @Override
  public SecurityPolicyUserDefinedField set(String fieldName, Object value) {
    return (SecurityPolicyUserDefinedField) super.set(fieldName, value);
  }

  @Override
  public SecurityPolicyUserDefinedField clone() {
    return (SecurityPolicyUserDefinedField) super.clone();
  }

}
