/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * This reservation type is specified by total resource amounts (e.g. total count of CPUs) and can
 * account for multiple instance SKUs. In other words, one can create instances of varying shapes
 * against this reservation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AllocationAggregateReservation extends com.google.api.client.json.GenericJson {

  /**
   * [Output only] List of resources currently in use.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AllocationAggregateReservationReservedResourceInfo> inUseResources;

  /**
   * List of reserved resources (CPUs, memory, accelerators).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AllocationAggregateReservationReservedResourceInfo> reservedResources;

  /**
   * The VM family that all instances scheduled against this reservation must belong to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String vmFamily;

  /**
   * The workload type of the instances that will target this reservation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String workloadType;

  /**
   * [Output only] List of resources currently in use.
   * @return value or {@code null} for none
   */
  public java.util.List<AllocationAggregateReservationReservedResourceInfo> getInUseResources() {
    return inUseResources;
  }

  /**
   * [Output only] List of resources currently in use.
   * @param inUseResources inUseResources or {@code null} for none
   */
  public AllocationAggregateReservation setInUseResources(java.util.List<AllocationAggregateReservationReservedResourceInfo> inUseResources) {
    this.inUseResources = inUseResources;
    return this;
  }

  /**
   * List of reserved resources (CPUs, memory, accelerators).
   * @return value or {@code null} for none
   */
  public java.util.List<AllocationAggregateReservationReservedResourceInfo> getReservedResources() {
    return reservedResources;
  }

  /**
   * List of reserved resources (CPUs, memory, accelerators).
   * @param reservedResources reservedResources or {@code null} for none
   */
  public AllocationAggregateReservation setReservedResources(java.util.List<AllocationAggregateReservationReservedResourceInfo> reservedResources) {
    this.reservedResources = reservedResources;
    return this;
  }

  /**
   * The VM family that all instances scheduled against this reservation must belong to.
   * @return value or {@code null} for none
   */
  public java.lang.String getVmFamily() {
    return vmFamily;
  }

  /**
   * The VM family that all instances scheduled against this reservation must belong to.
   * @param vmFamily vmFamily or {@code null} for none
   */
  public AllocationAggregateReservation setVmFamily(java.lang.String vmFamily) {
    this.vmFamily = vmFamily;
    return this;
  }

  /**
   * The workload type of the instances that will target this reservation.
   * @return value or {@code null} for none
   */
  public java.lang.String getWorkloadType() {
    return workloadType;
  }

  /**
   * The workload type of the instances that will target this reservation.
   * @param workloadType workloadType or {@code null} for none
   */
  public AllocationAggregateReservation setWorkloadType(java.lang.String workloadType) {
    this.workloadType = workloadType;
    return this;
  }

  @Override
  public AllocationAggregateReservation set(String fieldName, Object value) {
    return (AllocationAggregateReservation) super.set(fieldName, value);
  }

  @Override
  public AllocationAggregateReservation clone() {
    return (AllocationAggregateReservation) super.clone();
  }

}
