/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Status of a NAT Rule contained in this NAT.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RouterStatusNatStatusNatRuleStatus extends com.google.api.client.json.GenericJson {

  /**
   * A list of active IPs for NAT. Example: ["1.1.1.1", "179.12.26.133"].
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> activeNatIps;

  /**
   * A list of IPs for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> drainNatIps;

  /**
   * The number of extra IPs to allocate. This will be greater than 0 only if the existing IPs in
   * this NAT Rule are NOT enough to allow all configured VMs to use NAT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer minExtraIpsNeeded;

  /**
   * Number of VM endpoints (i.e., NICs) that have NAT Mappings from this NAT Rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer numVmEndpointsWithNatMappings;

  /**
   * Rule number of the rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer ruleNumber;

  /**
   * A list of active IPs for NAT. Example: ["1.1.1.1", "179.12.26.133"].
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getActiveNatIps() {
    return activeNatIps;
  }

  /**
   * A list of active IPs for NAT. Example: ["1.1.1.1", "179.12.26.133"].
   * @param activeNatIps activeNatIps or {@code null} for none
   */
  public RouterStatusNatStatusNatRuleStatus setActiveNatIps(java.util.List<java.lang.String> activeNatIps) {
    this.activeNatIps = activeNatIps;
    return this;
  }

  /**
   * A list of IPs for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDrainNatIps() {
    return drainNatIps;
  }

  /**
   * A list of IPs for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
   * @param drainNatIps drainNatIps or {@code null} for none
   */
  public RouterStatusNatStatusNatRuleStatus setDrainNatIps(java.util.List<java.lang.String> drainNatIps) {
    this.drainNatIps = drainNatIps;
    return this;
  }

  /**
   * The number of extra IPs to allocate. This will be greater than 0 only if the existing IPs in
   * this NAT Rule are NOT enough to allow all configured VMs to use NAT.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMinExtraIpsNeeded() {
    return minExtraIpsNeeded;
  }

  /**
   * The number of extra IPs to allocate. This will be greater than 0 only if the existing IPs in
   * this NAT Rule are NOT enough to allow all configured VMs to use NAT.
   * @param minExtraIpsNeeded minExtraIpsNeeded or {@code null} for none
   */
  public RouterStatusNatStatusNatRuleStatus setMinExtraIpsNeeded(java.lang.Integer minExtraIpsNeeded) {
    this.minExtraIpsNeeded = minExtraIpsNeeded;
    return this;
  }

  /**
   * Number of VM endpoints (i.e., NICs) that have NAT Mappings from this NAT Rule.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNumVmEndpointsWithNatMappings() {
    return numVmEndpointsWithNatMappings;
  }

  /**
   * Number of VM endpoints (i.e., NICs) that have NAT Mappings from this NAT Rule.
   * @param numVmEndpointsWithNatMappings numVmEndpointsWithNatMappings or {@code null} for none
   */
  public RouterStatusNatStatusNatRuleStatus setNumVmEndpointsWithNatMappings(java.lang.Integer numVmEndpointsWithNatMappings) {
    this.numVmEndpointsWithNatMappings = numVmEndpointsWithNatMappings;
    return this;
  }

  /**
   * Rule number of the rule.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRuleNumber() {
    return ruleNumber;
  }

  /**
   * Rule number of the rule.
   * @param ruleNumber ruleNumber or {@code null} for none
   */
  public RouterStatusNatStatusNatRuleStatus setRuleNumber(java.lang.Integer ruleNumber) {
    this.ruleNumber = ruleNumber;
    return this;
  }

  @Override
  public RouterStatusNatStatusNatRuleStatus set(String fieldName, Object value) {
    return (RouterStatusNatStatusNatRuleStatus) super.set(fieldName, value);
  }

  @Override
  public RouterStatusNatStatusNatRuleStatus clone() {
    return (RouterStatusNatStatusNatRuleStatus) super.clone();
  }

}
