/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerStatusAllInstancesConfig.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerStatusAllInstancesConfig extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Current all-instances configuration revision. This value is in RFC3339 text
   * format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String currentRevision;

  /**
   * [Output Only] A bit indicating whether this configuration has been applied to all managed
   * instances in the group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean effective;

  /**
   * [Output Only] Current all-instances configuration revision. This value is in RFC3339 text
   * format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCurrentRevision() {
    return currentRevision;
  }

  /**
   * [Output Only] Current all-instances configuration revision. This value is in RFC3339 text
   * format.
   * @param currentRevision currentRevision or {@code null} for none
   */
  public InstanceGroupManagerStatusAllInstancesConfig setCurrentRevision(java.lang.String currentRevision) {
    this.currentRevision = currentRevision;
    return this;
  }

  /**
   * [Output Only] A bit indicating whether this configuration has been applied to all managed
   * instances in the group.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEffective() {
    return effective;
  }

  /**
   * [Output Only] A bit indicating whether this configuration has been applied to all managed
   * instances in the group.
   * @param effective effective or {@code null} for none
   */
  public InstanceGroupManagerStatusAllInstancesConfig setEffective(java.lang.Boolean effective) {
    this.effective = effective;
    return this;
  }

  @Override
  public InstanceGroupManagerStatusAllInstancesConfig set(String fieldName, Object value) {
    return (InstanceGroupManagerStatusAllInstancesConfig) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerStatusAllInstancesConfig clone() {
    return (InstanceGroupManagerStatusAllInstancesConfig) super.clone();
  }

}
