/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Maintenance Info for ReservationBlocks.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GroupMaintenanceInfo extends com.google.api.client.json.GenericJson {

  /**
   * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the
   * block that have ongoing maintenance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maintenanceOngoingCount;

  /**
   * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the
   * block that have pending maintenance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maintenancePendingCount;

  /**
   * The type of maintenance for the reservation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String schedulingType;

  /**
   * Maintenance information on this group of VMs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpcomingMaintenance upcomingGroupMaintenance;

  /**
   * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the
   * block that have ongoing maintenance.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaintenanceOngoingCount() {
    return maintenanceOngoingCount;
  }

  /**
   * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the
   * block that have ongoing maintenance.
   * @param maintenanceOngoingCount maintenanceOngoingCount or {@code null} for none
   */
  public GroupMaintenanceInfo setMaintenanceOngoingCount(java.lang.Integer maintenanceOngoingCount) {
    this.maintenanceOngoingCount = maintenanceOngoingCount;
    return this;
  }

  /**
   * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the
   * block that have pending maintenance.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaintenancePendingCount() {
    return maintenancePendingCount;
  }

  /**
   * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the
   * block that have pending maintenance.
   * @param maintenancePendingCount maintenancePendingCount or {@code null} for none
   */
  public GroupMaintenanceInfo setMaintenancePendingCount(java.lang.Integer maintenancePendingCount) {
    this.maintenancePendingCount = maintenancePendingCount;
    return this;
  }

  /**
   * The type of maintenance for the reservation.
   * @return value or {@code null} for none
   */
  public java.lang.String getSchedulingType() {
    return schedulingType;
  }

  /**
   * The type of maintenance for the reservation.
   * @param schedulingType schedulingType or {@code null} for none
   */
  public GroupMaintenanceInfo setSchedulingType(java.lang.String schedulingType) {
    this.schedulingType = schedulingType;
    return this;
  }

  /**
   * Maintenance information on this group of VMs.
   * @return value or {@code null} for none
   */
  public UpcomingMaintenance getUpcomingGroupMaintenance() {
    return upcomingGroupMaintenance;
  }

  /**
   * Maintenance information on this group of VMs.
   * @param upcomingGroupMaintenance upcomingGroupMaintenance or {@code null} for none
   */
  public GroupMaintenanceInfo setUpcomingGroupMaintenance(UpcomingMaintenance upcomingGroupMaintenance) {
    this.upcomingGroupMaintenance = upcomingGroupMaintenance;
    return this;
  }

  @Override
  public GroupMaintenanceInfo set(String fieldName, Object value) {
    return (GroupMaintenanceInfo) super.set(fieldName, value);
  }

  @Override
  public GroupMaintenanceInfo clone() {
    return (GroupMaintenanceInfo) super.clone();
  }

}
