/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InterconnectGroupsCreateMembers.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectGroupsCreateMembers extends com.google.api.client.json.GenericJson {

  /**
   * How to behave when configured.topologyCapability.supportedSLA would not equal
   * intent.topologyCapability after this call.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String intentMismatchBehavior;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InterconnectGroupsCreateMembersInterconnectInput> interconnects;

  /**
   * Parameters for the Interconnects to create.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectGroupsCreateMembersInterconnectInput templateInterconnect;

  /**
   * How to behave when configured.topologyCapability.supportedSLA would not equal
   * intent.topologyCapability after this call.
   * @return value or {@code null} for none
   */
  public java.lang.String getIntentMismatchBehavior() {
    return intentMismatchBehavior;
  }

  /**
   * How to behave when configured.topologyCapability.supportedSLA would not equal
   * intent.topologyCapability after this call.
   * @param intentMismatchBehavior intentMismatchBehavior or {@code null} for none
   */
  public InterconnectGroupsCreateMembers setIntentMismatchBehavior(java.lang.String intentMismatchBehavior) {
    this.intentMismatchBehavior = intentMismatchBehavior;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.util.List<InterconnectGroupsCreateMembersInterconnectInput> getInterconnects() {
    return interconnects;
  }

  /**
   * @param interconnects interconnects or {@code null} for none
   */
  public InterconnectGroupsCreateMembers setInterconnects(java.util.List<InterconnectGroupsCreateMembersInterconnectInput> interconnects) {
    this.interconnects = interconnects;
    return this;
  }

  /**
   * Parameters for the Interconnects to create.
   * @return value or {@code null} for none
   */
  public InterconnectGroupsCreateMembersInterconnectInput getTemplateInterconnect() {
    return templateInterconnect;
  }

  /**
   * Parameters for the Interconnects to create.
   * @param templateInterconnect templateInterconnect or {@code null} for none
   */
  public InterconnectGroupsCreateMembers setTemplateInterconnect(InterconnectGroupsCreateMembersInterconnectInput templateInterconnect) {
    this.templateInterconnect = templateInterconnect;
    return this;
  }

  @Override
  public InterconnectGroupsCreateMembers set(String fieldName, Object value) {
    return (InterconnectGroupsCreateMembers) super.set(fieldName, value);
  }

  @Override
  public InterconnectGroupsCreateMembers clone() {
    return (InterconnectGroupsCreateMembers) super.clone();
  }

}
