/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a reservation subBlock resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReservationSubBlock extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The number of hosts that are allocated in this reservation subBlock.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer count;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] The number of instances that are currently in use on this reservation subBlock.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer inUseCount;

  /**
   * [Output Only] Type of the resource. Always compute#reservationSubBlock for reservation
   * subBlocks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Output Only] The name of this reservation subBlock generated by Google Compute Engine. The
   * name must be 1-63 characters long, and comply with RFC1035 @pattern
   * [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] The physical topology of the reservation subBlock.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReservationSubBlockPhysicalTopology physicalTopology;

  /**
   * Maintenance information for this reservation subBlock.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GroupMaintenanceInfo reservationSubBlockMaintenance;

  /**
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLinkWithId;

  /**
   * [Output Only] Status of the reservation subBlock.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * [Output Only] Zone in which the reservation subBlock resides.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * [Output Only] The number of hosts that are allocated in this reservation subBlock.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCount() {
    return count;
  }

  /**
   * [Output Only] The number of hosts that are allocated in this reservation subBlock.
   * @param count count or {@code null} for none
   */
  public ReservationSubBlock setCount(java.lang.Integer count) {
    this.count = count;
    return this;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public ReservationSubBlock setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public ReservationSubBlock setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] The number of instances that are currently in use on this reservation subBlock.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getInUseCount() {
    return inUseCount;
  }

  /**
   * [Output Only] The number of instances that are currently in use on this reservation subBlock.
   * @param inUseCount inUseCount or {@code null} for none
   */
  public ReservationSubBlock setInUseCount(java.lang.Integer inUseCount) {
    this.inUseCount = inUseCount;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#reservationSubBlock for reservation
   * subBlocks.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#reservationSubBlock for reservation
   * subBlocks.
   * @param kind kind or {@code null} for none
   */
  public ReservationSubBlock setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Output Only] The name of this reservation subBlock generated by Google Compute Engine. The
   * name must be 1-63 characters long, and comply with RFC1035 @pattern
   * [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * [Output Only] The name of this reservation subBlock generated by Google Compute Engine. The
   * name must be 1-63 characters long, and comply with RFC1035 @pattern
   * [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?
   * @param name name or {@code null} for none
   */
  public ReservationSubBlock setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] The physical topology of the reservation subBlock.
   * @return value or {@code null} for none
   */
  public ReservationSubBlockPhysicalTopology getPhysicalTopology() {
    return physicalTopology;
  }

  /**
   * [Output Only] The physical topology of the reservation subBlock.
   * @param physicalTopology physicalTopology or {@code null} for none
   */
  public ReservationSubBlock setPhysicalTopology(ReservationSubBlockPhysicalTopology physicalTopology) {
    this.physicalTopology = physicalTopology;
    return this;
  }

  /**
   * Maintenance information for this reservation subBlock.
   * @return value or {@code null} for none
   */
  public GroupMaintenanceInfo getReservationSubBlockMaintenance() {
    return reservationSubBlockMaintenance;
  }

  /**
   * Maintenance information for this reservation subBlock.
   * @param reservationSubBlockMaintenance reservationSubBlockMaintenance or {@code null} for none
   */
  public ReservationSubBlock setReservationSubBlockMaintenance(GroupMaintenanceInfo reservationSubBlockMaintenance) {
    this.reservationSubBlockMaintenance = reservationSubBlockMaintenance;
    return this;
  }

  /**
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public ReservationSubBlock setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLinkWithId() {
    return selfLinkWithId;
  }

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * @param selfLinkWithId selfLinkWithId or {@code null} for none
   */
  public ReservationSubBlock setSelfLinkWithId(java.lang.String selfLinkWithId) {
    this.selfLinkWithId = selfLinkWithId;
    return this;
  }

  /**
   * [Output Only] Status of the reservation subBlock.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * [Output Only] Status of the reservation subBlock.
   * @param status status or {@code null} for none
   */
  public ReservationSubBlock setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * [Output Only] Zone in which the reservation subBlock resides.
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * [Output Only] Zone in which the reservation subBlock resides.
   * @param zone zone or {@code null} for none
   */
  public ReservationSubBlock setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public ReservationSubBlock set(String fieldName, Object value) {
    return (ReservationSubBlock) super.set(fieldName, value);
  }

  @Override
  public ReservationSubBlock clone() {
    return (ReservationSubBlock) super.clone();
  }

}
