/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Message containing what to include in the cache key for a request for Cloud CDN.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BackendBucketCdnPolicyCacheKeyPolicy extends com.google.api.client.json.GenericJson {

  /**
   * Allows HTTP request headers (by name) to be used in the cache key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> includeHttpHeaders;

  /**
   * Names of query string parameters to include in cache keys. Default parameters are always
   * included. '&' and '=' will be percent encoded and not treated as delimiters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> queryStringWhitelist;

  /**
   * Allows HTTP request headers (by name) to be used in the cache key.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getIncludeHttpHeaders() {
    return includeHttpHeaders;
  }

  /**
   * Allows HTTP request headers (by name) to be used in the cache key.
   * @param includeHttpHeaders includeHttpHeaders or {@code null} for none
   */
  public BackendBucketCdnPolicyCacheKeyPolicy setIncludeHttpHeaders(java.util.List<java.lang.String> includeHttpHeaders) {
    this.includeHttpHeaders = includeHttpHeaders;
    return this;
  }

  /**
   * Names of query string parameters to include in cache keys. Default parameters are always
   * included. '&' and '=' will be percent encoded and not treated as delimiters.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getQueryStringWhitelist() {
    return queryStringWhitelist;
  }

  /**
   * Names of query string parameters to include in cache keys. Default parameters are always
   * included. '&' and '=' will be percent encoded and not treated as delimiters.
   * @param queryStringWhitelist queryStringWhitelist or {@code null} for none
   */
  public BackendBucketCdnPolicyCacheKeyPolicy setQueryStringWhitelist(java.util.List<java.lang.String> queryStringWhitelist) {
    this.queryStringWhitelist = queryStringWhitelist;
    return this;
  }

  @Override
  public BackendBucketCdnPolicyCacheKeyPolicy set(String fieldName, Object value) {
    return (BackendBucketCdnPolicyCacheKeyPolicy) super.set(fieldName, value);
  }

  @Override
  public BackendBucketCdnPolicyCacheKeyPolicy clone() {
    return (BackendBucketCdnPolicyCacheKeyPolicy) super.clone();
  }

}
