/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Preserved state for a given instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PreservedState extends com.google.api.client.json.GenericJson {

  /**
   * Preserved disks defined for this instance. This map is keyed with the device names of the
   * disks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, PreservedStatePreservedDisk> disks;

  /**
   * Preserved external IPs defined for this instance. This map is keyed with the name of the
   * network interface.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, PreservedStatePreservedNetworkIp> externalIPs;

  /**
   * Preserved internal IPs defined for this instance. This map is keyed with the name of the
   * network interface.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, PreservedStatePreservedNetworkIp> internalIPs;

  /**
   * Preserved metadata defined for this instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> metadata;

  /**
   * Preserved disks defined for this instance. This map is keyed with the device names of the
   * disks.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, PreservedStatePreservedDisk> getDisks() {
    return disks;
  }

  /**
   * Preserved disks defined for this instance. This map is keyed with the device names of the
   * disks.
   * @param disks disks or {@code null} for none
   */
  public PreservedState setDisks(java.util.Map<String, PreservedStatePreservedDisk> disks) {
    this.disks = disks;
    return this;
  }

  /**
   * Preserved external IPs defined for this instance. This map is keyed with the name of the
   * network interface.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, PreservedStatePreservedNetworkIp> getExternalIPs() {
    return externalIPs;
  }

  /**
   * Preserved external IPs defined for this instance. This map is keyed with the name of the
   * network interface.
   * @param externalIPs externalIPs or {@code null} for none
   */
  public PreservedState setExternalIPs(java.util.Map<String, PreservedStatePreservedNetworkIp> externalIPs) {
    this.externalIPs = externalIPs;
    return this;
  }

  /**
   * Preserved internal IPs defined for this instance. This map is keyed with the name of the
   * network interface.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, PreservedStatePreservedNetworkIp> getInternalIPs() {
    return internalIPs;
  }

  /**
   * Preserved internal IPs defined for this instance. This map is keyed with the name of the
   * network interface.
   * @param internalIPs internalIPs or {@code null} for none
   */
  public PreservedState setInternalIPs(java.util.Map<String, PreservedStatePreservedNetworkIp> internalIPs) {
    this.internalIPs = internalIPs;
    return this;
  }

  /**
   * Preserved metadata defined for this instance.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getMetadata() {
    return metadata;
  }

  /**
   * Preserved metadata defined for this instance.
   * @param metadata metadata or {@code null} for none
   */
  public PreservedState setMetadata(java.util.Map<String, java.lang.String> metadata) {
    this.metadata = metadata;
    return this;
  }

  @Override
  public PreservedState set(String fieldName, Object value) {
    return (PreservedState) super.set(fieldName, value);
  }

  @Override
  public PreservedState clone() {
    return (PreservedState) super.clone();
  }

}
