/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A PublicDelegatedPrefix resource represents an IP block within a PublicAdvertisedPrefix that is
 * configured within a single cloud scope (global or region). IPs in the block can be allocated to
 * resources within that scope. Public delegated prefixes may be further broken up into smaller IP
 * blocks in the same scope as the parent block.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PublicDelegatedPrefix extends com.google.api.client.json.GenericJson {

  /**
   * The allocatable prefix length supported by this public delegated prefix. This field is optional
   * and cannot be set for prefixes in DELEGATION mode. It cannot be set for IPv4 prefixes either,
   * and it always defaults to 32.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer allocatablePrefixLength;

  /**
   * [Output Only] The version of BYOIP API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String byoipApiVersion;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a new PublicDelegatedPrefix.
   * An up-to-date fingerprint must be provided in order to update the PublicDelegatedPrefix,
   * otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint,
   * make a get() request to retrieve a PublicDelegatedPrefix.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fingerprint;

  /**
   * [Output Only] The unique identifier for the resource type. The server generates this
   * identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * The IP address range, in CIDR format, represented by this public delegated prefix.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipCidrRange;

  /**
   * If true, the prefix will be live migrated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isLiveMigration;

  /**
   * [Output Only] Type of the resource. Always compute#publicDelegatedPrefix for public delegated
   * prefixes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The public delegated prefix mode for IPv6 only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mode;

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String parentPrefix;

  /**
   * The list of sub public delegated prefixes that exist for this public delegated prefix.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PublicDelegatedPrefixPublicDelegatedSubPrefix> publicDelegatedSubPrefixs;

  /**
   * [Output Only] URL of the region where the public delegated prefix resides. This field applies
   * only to the region resource. You must specify this field as part of the HTTP request URL. It is
   * not settable as a field in the request body.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] The status of the public delegated prefix, which can be one of following values:
   * - `INITIALIZING` The public delegated prefix is being initialized and addresses cannot be
   * created yet. - `READY_TO_ANNOUNCE` The public delegated prefix is a live migration prefix and
   * is active. - `ANNOUNCED` The public delegated prefix is announced and ready to use. -
   * `DELETING` The public delegated prefix is being deprovsioned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * The allocatable prefix length supported by this public delegated prefix. This field is optional
   * and cannot be set for prefixes in DELEGATION mode. It cannot be set for IPv4 prefixes either,
   * and it always defaults to 32.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAllocatablePrefixLength() {
    return allocatablePrefixLength;
  }

  /**
   * The allocatable prefix length supported by this public delegated prefix. This field is optional
   * and cannot be set for prefixes in DELEGATION mode. It cannot be set for IPv4 prefixes either,
   * and it always defaults to 32.
   * @param allocatablePrefixLength allocatablePrefixLength or {@code null} for none
   */
  public PublicDelegatedPrefix setAllocatablePrefixLength(java.lang.Integer allocatablePrefixLength) {
    this.allocatablePrefixLength = allocatablePrefixLength;
    return this;
  }

  /**
   * [Output Only] The version of BYOIP API.
   * @return value or {@code null} for none
   */
  public java.lang.String getByoipApiVersion() {
    return byoipApiVersion;
  }

  /**
   * [Output Only] The version of BYOIP API.
   * @param byoipApiVersion byoipApiVersion or {@code null} for none
   */
  public PublicDelegatedPrefix setByoipApiVersion(java.lang.String byoipApiVersion) {
    this.byoipApiVersion = byoipApiVersion;
    return this;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public PublicDelegatedPrefix setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public PublicDelegatedPrefix setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a new PublicDelegatedPrefix.
   * An up-to-date fingerprint must be provided in order to update the PublicDelegatedPrefix,
   * otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint,
   * make a get() request to retrieve a PublicDelegatedPrefix.
   * @see #decodeFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getFingerprint() {
    return fingerprint;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a new PublicDelegatedPrefix.
   * An up-to-date fingerprint must be provided in order to update the PublicDelegatedPrefix,
   * otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint,
   * make a get() request to retrieve a PublicDelegatedPrefix.
   * @see #getFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(fingerprint);
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a new PublicDelegatedPrefix.
   * An up-to-date fingerprint must be provided in order to update the PublicDelegatedPrefix,
   * otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint,
   * make a get() request to retrieve a PublicDelegatedPrefix.
   * @see #encodeFingerprint()
   * @param fingerprint fingerprint or {@code null} for none
   */
  public PublicDelegatedPrefix setFingerprint(java.lang.String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a new PublicDelegatedPrefix.
   * An up-to-date fingerprint must be provided in order to update the PublicDelegatedPrefix,
   * otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint,
   * make a get() request to retrieve a PublicDelegatedPrefix.
   * @see #setFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public PublicDelegatedPrefix encodeFingerprint(byte[] fingerprint) {
    this.fingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(fingerprint);
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource type. The server generates this
   * identifier.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource type. The server generates this
   * identifier.
   * @param id id or {@code null} for none
   */
  public PublicDelegatedPrefix setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * The IP address range, in CIDR format, represented by this public delegated prefix.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpCidrRange() {
    return ipCidrRange;
  }

  /**
   * The IP address range, in CIDR format, represented by this public delegated prefix.
   * @param ipCidrRange ipCidrRange or {@code null} for none
   */
  public PublicDelegatedPrefix setIpCidrRange(java.lang.String ipCidrRange) {
    this.ipCidrRange = ipCidrRange;
    return this;
  }

  /**
   * If true, the prefix will be live migrated.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsLiveMigration() {
    return isLiveMigration;
  }

  /**
   * If true, the prefix will be live migrated.
   * @param isLiveMigration isLiveMigration or {@code null} for none
   */
  public PublicDelegatedPrefix setIsLiveMigration(java.lang.Boolean isLiveMigration) {
    this.isLiveMigration = isLiveMigration;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#publicDelegatedPrefix for public delegated
   * prefixes.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#publicDelegatedPrefix for public delegated
   * prefixes.
   * @param kind kind or {@code null} for none
   */
  public PublicDelegatedPrefix setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The public delegated prefix mode for IPv6 only.
   * @return value or {@code null} for none
   */
  public java.lang.String getMode() {
    return mode;
  }

  /**
   * The public delegated prefix mode for IPv6 only.
   * @param mode mode or {@code null} for none
   */
  public PublicDelegatedPrefix setMode(java.lang.String mode) {
    this.mode = mode;
    return this;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public PublicDelegatedPrefix setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
   * @return value or {@code null} for none
   */
  public java.lang.String getParentPrefix() {
    return parentPrefix;
  }

  /**
   * The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
   * @param parentPrefix parentPrefix or {@code null} for none
   */
  public PublicDelegatedPrefix setParentPrefix(java.lang.String parentPrefix) {
    this.parentPrefix = parentPrefix;
    return this;
  }

  /**
   * The list of sub public delegated prefixes that exist for this public delegated prefix.
   * @return value or {@code null} for none
   */
  public java.util.List<PublicDelegatedPrefixPublicDelegatedSubPrefix> getPublicDelegatedSubPrefixs() {
    return publicDelegatedSubPrefixs;
  }

  /**
   * The list of sub public delegated prefixes that exist for this public delegated prefix.
   * @param publicDelegatedSubPrefixs publicDelegatedSubPrefixs or {@code null} for none
   */
  public PublicDelegatedPrefix setPublicDelegatedSubPrefixs(java.util.List<PublicDelegatedPrefixPublicDelegatedSubPrefix> publicDelegatedSubPrefixs) {
    this.publicDelegatedSubPrefixs = publicDelegatedSubPrefixs;
    return this;
  }

  /**
   * [Output Only] URL of the region where the public delegated prefix resides. This field applies
   * only to the region resource. You must specify this field as part of the HTTP request URL. It is
   * not settable as a field in the request body.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * [Output Only] URL of the region where the public delegated prefix resides. This field applies
   * only to the region resource. You must specify this field as part of the HTTP request URL. It is
   * not settable as a field in the request body.
   * @param region region or {@code null} for none
   */
  public PublicDelegatedPrefix setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public PublicDelegatedPrefix setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * [Output Only] The status of the public delegated prefix, which can be one of following values:
   * - `INITIALIZING` The public delegated prefix is being initialized and addresses cannot be
   * created yet. - `READY_TO_ANNOUNCE` The public delegated prefix is a live migration prefix and
   * is active. - `ANNOUNCED` The public delegated prefix is announced and ready to use. -
   * `DELETING` The public delegated prefix is being deprovsioned.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * [Output Only] The status of the public delegated prefix, which can be one of following values:
   * - `INITIALIZING` The public delegated prefix is being initialized and addresses cannot be
   * created yet. - `READY_TO_ANNOUNCE` The public delegated prefix is a live migration prefix and
   * is active. - `ANNOUNCED` The public delegated prefix is announced and ready to use. -
   * `DELETING` The public delegated prefix is being deprovsioned.
   * @param status status or {@code null} for none
   */
  public PublicDelegatedPrefix setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  @Override
  public PublicDelegatedPrefix set(String fieldName, Object value) {
    return (PublicDelegatedPrefix) super.set(fieldName, value);
  }

  @Override
  public PublicDelegatedPrefix clone() {
    return (PublicDelegatedPrefix) super.clone();
  }

}
