/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for CacheInvalidationRule.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CacheInvalidationRule extends com.google.api.client.json.GenericJson {

  /**
   * A list of cache tags used to identify cached objects. - Cache tags are specified when the
   * response is first cached, by setting the `Cache-Tag` response header at the origin. - Multiple
   * cache tags in the same invalidation request are treated as Boolean `OR` - for example, `tag1 OR
   * tag2 OR tag3`. - If other fields are also specified, these are treated as Boolean `AND` with
   * any tags. Up to 10 tags can be specified in a single invalidation request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> cacheTags;

  /**
   * If set, this invalidation rule will only apply to requests with a Host header matching host.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String host;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String path;

  /**
   * A list of cache tags used to identify cached objects. - Cache tags are specified when the
   * response is first cached, by setting the `Cache-Tag` response header at the origin. - Multiple
   * cache tags in the same invalidation request are treated as Boolean `OR` - for example, `tag1 OR
   * tag2 OR tag3`. - If other fields are also specified, these are treated as Boolean `AND` with
   * any tags. Up to 10 tags can be specified in a single invalidation request.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getCacheTags() {
    return cacheTags;
  }

  /**
   * A list of cache tags used to identify cached objects. - Cache tags are specified when the
   * response is first cached, by setting the `Cache-Tag` response header at the origin. - Multiple
   * cache tags in the same invalidation request are treated as Boolean `OR` - for example, `tag1 OR
   * tag2 OR tag3`. - If other fields are also specified, these are treated as Boolean `AND` with
   * any tags. Up to 10 tags can be specified in a single invalidation request.
   * @param cacheTags cacheTags or {@code null} for none
   */
  public CacheInvalidationRule setCacheTags(java.util.List<java.lang.String> cacheTags) {
    this.cacheTags = cacheTags;
    return this;
  }

  /**
   * If set, this invalidation rule will only apply to requests with a Host header matching host.
   * @return value or {@code null} for none
   */
  public java.lang.String getHost() {
    return host;
  }

  /**
   * If set, this invalidation rule will only apply to requests with a Host header matching host.
   * @param host host or {@code null} for none
   */
  public CacheInvalidationRule setHost(java.lang.String host) {
    this.host = host;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getPath() {
    return path;
  }

  /**
   * @param path path or {@code null} for none
   */
  public CacheInvalidationRule setPath(java.lang.String path) {
    this.path = path;
    return this;
  }

  @Override
  public CacheInvalidationRule set(String fieldName, Object value) {
    return (CacheInvalidationRule) super.set(fieldName, value);
  }

  @Override
  public CacheInvalidationRule clone() {
    return (CacheInvalidationRule) super.clone();
  }

}
