/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * LINT.IfChange
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectGroupsCreateMembersInterconnectInput extends com.google.api.client.json.GenericJson {

  /**
   * Administrative status of the interconnect. When this is set to true, the Interconnect is
   * functional and can carry traffic. When set to false, no packets can be carried over the
   * interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean adminEnabled;

  /**
   * Customer name, to put in the Letter of Authorization as the party authorized to request a
   * crossconnect.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customerName;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * A zone-free location to use for all Interconnects created in this call, like "iad-1234".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String facility;

  /**
   * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed
   * interconnection shared between customers though a partner. - DEDICATED: A dedicated physical
   * interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of
   * DEDICATED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String interconnectType;

  /**
   * Type of link requested, which can take one of the following values: -
   * LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G
   * Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note
   * that this field indicates the speed of each of the links in the bundle, not the speed of the
   * entire bundle.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String linkType;

  /**
   * Name of the Interconnects to be created. This must be specified on the template and/or on each
   * individual interconnect. The name, if not empty, must be 1-63 characters long, and comply with
   * RFC1035. Specifically, any nonempty name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase
   * letter, and all following characters must be a dash, lowercase letter, or digit, except the
   * last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Email address to contact the customer NOC for operations and maintenance notifications
   * regarding this Interconnect. If specified, this will be used for notifications in addition to
   * all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This
   * field is required for users who sign up for Cloud Interconnect using workforce identity
   * federation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nocContactEmail;

  /**
   * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of
   * Google's network that the interconnect is connected to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String remoteLocation;

  /**
   * Optional. List of features requested for this Interconnect connection, which can take one of
   * the following values: - IF_MACSEC If specified then the connection is created on MACsec capable
   * hardware ports. If not specified, the default value is false, which allocates non-MACsec
   * capable ports first if available. This parameter can be provided only with Interconnect INSERT.
   * It isn't valid for Interconnect PATCH.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> requestedFeatures;

  /**
   * Target number of physical links in the link bundle, as requested by the customer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer requestedLinkCount;

  /**
   * Administrative status of the interconnect. When this is set to true, the Interconnect is
   * functional and can carry traffic. When set to false, no packets can be carried over the
   * interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAdminEnabled() {
    return adminEnabled;
  }

  /**
   * Administrative status of the interconnect. When this is set to true, the Interconnect is
   * functional and can carry traffic. When set to false, no packets can be carried over the
   * interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
   * @param adminEnabled adminEnabled or {@code null} for none
   */
  public InterconnectGroupsCreateMembersInterconnectInput setAdminEnabled(java.lang.Boolean adminEnabled) {
    this.adminEnabled = adminEnabled;
    return this;
  }

  /**
   * Customer name, to put in the Letter of Authorization as the party authorized to request a
   * crossconnect.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomerName() {
    return customerName;
  }

  /**
   * Customer name, to put in the Letter of Authorization as the party authorized to request a
   * crossconnect.
   * @param customerName customerName or {@code null} for none
   */
  public InterconnectGroupsCreateMembersInterconnectInput setCustomerName(java.lang.String customerName) {
    this.customerName = customerName;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public InterconnectGroupsCreateMembersInterconnectInput setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * A zone-free location to use for all Interconnects created in this call, like "iad-1234".
   * @return value or {@code null} for none
   */
  public java.lang.String getFacility() {
    return facility;
  }

  /**
   * A zone-free location to use for all Interconnects created in this call, like "iad-1234".
   * @param facility facility or {@code null} for none
   */
  public InterconnectGroupsCreateMembersInterconnectInput setFacility(java.lang.String facility) {
    this.facility = facility;
    return this;
  }

  /**
   * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed
   * interconnection shared between customers though a partner. - DEDICATED: A dedicated physical
   * interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of
   * DEDICATED.
   * @return value or {@code null} for none
   */
  public java.lang.String getInterconnectType() {
    return interconnectType;
  }

  /**
   * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed
   * interconnection shared between customers though a partner. - DEDICATED: A dedicated physical
   * interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of
   * DEDICATED.
   * @param interconnectType interconnectType or {@code null} for none
   */
  public InterconnectGroupsCreateMembersInterconnectInput setInterconnectType(java.lang.String interconnectType) {
    this.interconnectType = interconnectType;
    return this;
  }

  /**
   * Type of link requested, which can take one of the following values: -
   * LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G
   * Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note
   * that this field indicates the speed of each of the links in the bundle, not the speed of the
   * entire bundle.
   * @return value or {@code null} for none
   */
  public java.lang.String getLinkType() {
    return linkType;
  }

  /**
   * Type of link requested, which can take one of the following values: -
   * LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G
   * Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note
   * that this field indicates the speed of each of the links in the bundle, not the speed of the
   * entire bundle.
   * @param linkType linkType or {@code null} for none
   */
  public InterconnectGroupsCreateMembersInterconnectInput setLinkType(java.lang.String linkType) {
    this.linkType = linkType;
    return this;
  }

  /**
   * Name of the Interconnects to be created. This must be specified on the template and/or on each
   * individual interconnect. The name, if not empty, must be 1-63 characters long, and comply with
   * RFC1035. Specifically, any nonempty name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase
   * letter, and all following characters must be a dash, lowercase letter, or digit, except the
   * last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the Interconnects to be created. This must be specified on the template and/or on each
   * individual interconnect. The name, if not empty, must be 1-63 characters long, and comply with
   * RFC1035. Specifically, any nonempty name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase
   * letter, and all following characters must be a dash, lowercase letter, or digit, except the
   * last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public InterconnectGroupsCreateMembersInterconnectInput setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Email address to contact the customer NOC for operations and maintenance notifications
   * regarding this Interconnect. If specified, this will be used for notifications in addition to
   * all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This
   * field is required for users who sign up for Cloud Interconnect using workforce identity
   * federation.
   * @return value or {@code null} for none
   */
  public java.lang.String getNocContactEmail() {
    return nocContactEmail;
  }

  /**
   * Email address to contact the customer NOC for operations and maintenance notifications
   * regarding this Interconnect. If specified, this will be used for notifications in addition to
   * all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This
   * field is required for users who sign up for Cloud Interconnect using workforce identity
   * federation.
   * @param nocContactEmail nocContactEmail or {@code null} for none
   */
  public InterconnectGroupsCreateMembersInterconnectInput setNocContactEmail(java.lang.String nocContactEmail) {
    this.nocContactEmail = nocContactEmail;
    return this;
  }

  /**
   * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of
   * Google's network that the interconnect is connected to.
   * @return value or {@code null} for none
   */
  public java.lang.String getRemoteLocation() {
    return remoteLocation;
  }

  /**
   * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of
   * Google's network that the interconnect is connected to.
   * @param remoteLocation remoteLocation or {@code null} for none
   */
  public InterconnectGroupsCreateMembersInterconnectInput setRemoteLocation(java.lang.String remoteLocation) {
    this.remoteLocation = remoteLocation;
    return this;
  }

  /**
   * Optional. List of features requested for this Interconnect connection, which can take one of
   * the following values: - IF_MACSEC If specified then the connection is created on MACsec capable
   * hardware ports. If not specified, the default value is false, which allocates non-MACsec
   * capable ports first if available. This parameter can be provided only with Interconnect INSERT.
   * It isn't valid for Interconnect PATCH.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRequestedFeatures() {
    return requestedFeatures;
  }

  /**
   * Optional. List of features requested for this Interconnect connection, which can take one of
   * the following values: - IF_MACSEC If specified then the connection is created on MACsec capable
   * hardware ports. If not specified, the default value is false, which allocates non-MACsec
   * capable ports first if available. This parameter can be provided only with Interconnect INSERT.
   * It isn't valid for Interconnect PATCH.
   * @param requestedFeatures requestedFeatures or {@code null} for none
   */
  public InterconnectGroupsCreateMembersInterconnectInput setRequestedFeatures(java.util.List<java.lang.String> requestedFeatures) {
    this.requestedFeatures = requestedFeatures;
    return this;
  }

  /**
   * Target number of physical links in the link bundle, as requested by the customer.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRequestedLinkCount() {
    return requestedLinkCount;
  }

  /**
   * Target number of physical links in the link bundle, as requested by the customer.
   * @param requestedLinkCount requestedLinkCount or {@code null} for none
   */
  public InterconnectGroupsCreateMembersInterconnectInput setRequestedLinkCount(java.lang.Integer requestedLinkCount) {
    this.requestedLinkCount = requestedLinkCount;
    return this;
  }

  @Override
  public InterconnectGroupsCreateMembersInterconnectInput set(String fieldName, Object value) {
    return (InterconnectGroupsCreateMembersInterconnectInput) super.set(fieldName, value);
  }

  @Override
  public InterconnectGroupsCreateMembersInterconnectInput clone() {
    return (InterconnectGroupsCreateMembersInterconnectInput) super.clone();
  }

}
