/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for PacketMirroringMirroredResourceInfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PacketMirroringMirroredResourceInfo extends com.google.api.client.json.GenericJson {

  /**
   * A set of virtual machine instances that are being mirrored. They must live in zones contained
   * in the same region as this packetMirroring. Note that this config will apply only to those
   * network interfaces of the Instances that belong to the network specified in this
   * packetMirroring. You may specify a maximum of 50 Instances.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PacketMirroringMirroredResourceInfoInstanceInfo> instances;

  /**
   * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must
   * live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PacketMirroringMirroredResourceInfoSubnetInfo> subnetworks;

  /**
   * A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags
   * will be mirrored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> tags;

  /**
   * A set of virtual machine instances that are being mirrored. They must live in zones contained
   * in the same region as this packetMirroring. Note that this config will apply only to those
   * network interfaces of the Instances that belong to the network specified in this
   * packetMirroring. You may specify a maximum of 50 Instances.
   * @return value or {@code null} for none
   */
  public java.util.List<PacketMirroringMirroredResourceInfoInstanceInfo> getInstances() {
    return instances;
  }

  /**
   * A set of virtual machine instances that are being mirrored. They must live in zones contained
   * in the same region as this packetMirroring. Note that this config will apply only to those
   * network interfaces of the Instances that belong to the network specified in this
   * packetMirroring. You may specify a maximum of 50 Instances.
   * @param instances instances or {@code null} for none
   */
  public PacketMirroringMirroredResourceInfo setInstances(java.util.List<PacketMirroringMirroredResourceInfoInstanceInfo> instances) {
    this.instances = instances;
    return this;
  }

  /**
   * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must
   * live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
   * @return value or {@code null} for none
   */
  public java.util.List<PacketMirroringMirroredResourceInfoSubnetInfo> getSubnetworks() {
    return subnetworks;
  }

  /**
   * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must
   * live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
   * @param subnetworks subnetworks or {@code null} for none
   */
  public PacketMirroringMirroredResourceInfo setSubnetworks(java.util.List<PacketMirroringMirroredResourceInfoSubnetInfo> subnetworks) {
    this.subnetworks = subnetworks;
    return this;
  }

  /**
   * A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags
   * will be mirrored.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTags() {
    return tags;
  }

  /**
   * A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags
   * will be mirrored.
   * @param tags tags or {@code null} for none
   */
  public PacketMirroringMirroredResourceInfo setTags(java.util.List<java.lang.String> tags) {
    this.tags = tags;
    return this;
  }

  @Override
  public PacketMirroringMirroredResourceInfo set(String fieldName, Object value) {
    return (PacketMirroringMirroredResourceInfo) super.set(fieldName, value);
  }

  @Override
  public PacketMirroringMirroredResourceInfo clone() {
    return (PacketMirroringMirroredResourceInfo) super.clone();
  }

}
