/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Health information for the reservation block.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReservationBlockHealthInfo extends com.google.api.client.json.GenericJson {

  /**
   * The number of subBlocks that are degraded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer degradedSubBlockCount;

  /**
   * The health status of the reservation block.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String healthStatus;

  /**
   * The number of subBlocks that are healthy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer healthySubBlockCount;

  /**
   * The number of subBlocks that are degraded.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getDegradedSubBlockCount() {
    return degradedSubBlockCount;
  }

  /**
   * The number of subBlocks that are degraded.
   * @param degradedSubBlockCount degradedSubBlockCount or {@code null} for none
   */
  public ReservationBlockHealthInfo setDegradedSubBlockCount(java.lang.Integer degradedSubBlockCount) {
    this.degradedSubBlockCount = degradedSubBlockCount;
    return this;
  }

  /**
   * The health status of the reservation block.
   * @return value or {@code null} for none
   */
  public java.lang.String getHealthStatus() {
    return healthStatus;
  }

  /**
   * The health status of the reservation block.
   * @param healthStatus healthStatus or {@code null} for none
   */
  public ReservationBlockHealthInfo setHealthStatus(java.lang.String healthStatus) {
    this.healthStatus = healthStatus;
    return this;
  }

  /**
   * The number of subBlocks that are healthy.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getHealthySubBlockCount() {
    return healthySubBlockCount;
  }

  /**
   * The number of subBlocks that are healthy.
   * @param healthySubBlockCount healthySubBlockCount or {@code null} for none
   */
  public ReservationBlockHealthInfo setHealthySubBlockCount(java.lang.Integer healthySubBlockCount) {
    this.healthySubBlockCount = healthySubBlockCount;
    return this;
  }

  @Override
  public ReservationBlockHealthInfo set(String fieldName, Object value) {
    return (ReservationBlockHealthInfo) super.set(fieldName, value);
  }

  @Override
  public ReservationBlockHealthInfo clone() {
    return (ReservationBlockHealthInfo) super.clone();
  }

}
