/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Commitment for a particular hardware resource (a commitment is composed of one or more of these).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourceCommitment extends com.google.api.client.json.GenericJson {

  /**
   * Name of the accelerator type or GPU resource. Specify this field only when the type of hardware
   * resource is ACCELERATOR.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String acceleratorType;

  /**
   * The quantity of the hardware resource that you want to commit to purchasing (in a type-
   * dependent unit). - For vCPUs, you must specify an integer value. - For memory, you specify the
   * amount of MB that you want. The value you specify must be a multiple of 256 MB, with up to 6.5
   * GB of memory per every vCPU. - For GPUs, you must specify an integer value. - For Local SSD
   * disks, you must specify the amount in GB. The size of a single Local SSD disk is 375 GB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long amount;

  /**
   * The type of hardware resource that you want to specify. You can specify any of the following
   * values: - VCPU - MEMORY - LOCAL_SSD - ACCELERATOR Specify as a separate entry in the list for
   * each individual resource type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Name of the accelerator type or GPU resource. Specify this field only when the type of hardware
   * resource is ACCELERATOR.
   * @return value or {@code null} for none
   */
  public java.lang.String getAcceleratorType() {
    return acceleratorType;
  }

  /**
   * Name of the accelerator type or GPU resource. Specify this field only when the type of hardware
   * resource is ACCELERATOR.
   * @param acceleratorType acceleratorType or {@code null} for none
   */
  public ResourceCommitment setAcceleratorType(java.lang.String acceleratorType) {
    this.acceleratorType = acceleratorType;
    return this;
  }

  /**
   * The quantity of the hardware resource that you want to commit to purchasing (in a type-
   * dependent unit). - For vCPUs, you must specify an integer value. - For memory, you specify the
   * amount of MB that you want. The value you specify must be a multiple of 256 MB, with up to 6.5
   * GB of memory per every vCPU. - For GPUs, you must specify an integer value. - For Local SSD
   * disks, you must specify the amount in GB. The size of a single Local SSD disk is 375 GB.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAmount() {
    return amount;
  }

  /**
   * The quantity of the hardware resource that you want to commit to purchasing (in a type-
   * dependent unit). - For vCPUs, you must specify an integer value. - For memory, you specify the
   * amount of MB that you want. The value you specify must be a multiple of 256 MB, with up to 6.5
   * GB of memory per every vCPU. - For GPUs, you must specify an integer value. - For Local SSD
   * disks, you must specify the amount in GB. The size of a single Local SSD disk is 375 GB.
   * @param amount amount or {@code null} for none
   */
  public ResourceCommitment setAmount(java.lang.Long amount) {
    this.amount = amount;
    return this;
  }

  /**
   * The type of hardware resource that you want to specify. You can specify any of the following
   * values: - VCPU - MEMORY - LOCAL_SSD - ACCELERATOR Specify as a separate entry in the list for
   * each individual resource type.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of hardware resource that you want to specify. You can specify any of the following
   * values: - VCPU - MEMORY - LOCAL_SSD - ACCELERATOR Specify as a separate entry in the list for
   * each individual resource type.
   * @param type type or {@code null} for none
   */
  public ResourceCommitment setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public ResourceCommitment set(String fieldName, Object value) {
    return (ResourceCommitment) super.set(fieldName, value);
  }

  @Override
  public ResourceCommitment clone() {
    return (ResourceCommitment) super.clone();
  }

}
