/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * [Output Only] Contains output only fields.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AllocationResourceStatus extends com.google.api.client.json.GenericJson {

  /**
   * [Output only] Health information for the reservation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AllocationResourceStatusHealthInfo healthInfo;

  /**
   * The number of reservation blocks associated with this reservation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer reservationBlockCount;

  /**
   * Maintenance information for this reservation
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GroupMaintenanceInfo reservationMaintenance;

  /**
   * Allocation Properties of this reservation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AllocationResourceStatusSpecificSKUAllocation specificSkuAllocation;

  /**
   * [Output only] Health information for the reservation.
   * @return value or {@code null} for none
   */
  public AllocationResourceStatusHealthInfo getHealthInfo() {
    return healthInfo;
  }

  /**
   * [Output only] Health information for the reservation.
   * @param healthInfo healthInfo or {@code null} for none
   */
  public AllocationResourceStatus setHealthInfo(AllocationResourceStatusHealthInfo healthInfo) {
    this.healthInfo = healthInfo;
    return this;
  }

  /**
   * The number of reservation blocks associated with this reservation.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getReservationBlockCount() {
    return reservationBlockCount;
  }

  /**
   * The number of reservation blocks associated with this reservation.
   * @param reservationBlockCount reservationBlockCount or {@code null} for none
   */
  public AllocationResourceStatus setReservationBlockCount(java.lang.Integer reservationBlockCount) {
    this.reservationBlockCount = reservationBlockCount;
    return this;
  }

  /**
   * Maintenance information for this reservation
   * @return value or {@code null} for none
   */
  public GroupMaintenanceInfo getReservationMaintenance() {
    return reservationMaintenance;
  }

  /**
   * Maintenance information for this reservation
   * @param reservationMaintenance reservationMaintenance or {@code null} for none
   */
  public AllocationResourceStatus setReservationMaintenance(GroupMaintenanceInfo reservationMaintenance) {
    this.reservationMaintenance = reservationMaintenance;
    return this;
  }

  /**
   * Allocation Properties of this reservation.
   * @return value or {@code null} for none
   */
  public AllocationResourceStatusSpecificSKUAllocation getSpecificSkuAllocation() {
    return specificSkuAllocation;
  }

  /**
   * Allocation Properties of this reservation.
   * @param specificSkuAllocation specificSkuAllocation or {@code null} for none
   */
  public AllocationResourceStatus setSpecificSkuAllocation(AllocationResourceStatusSpecificSKUAllocation specificSkuAllocation) {
    this.specificSkuAllocation = specificSkuAllocation;
    return this;
  }

  @Override
  public AllocationResourceStatus set(String fieldName, Object value) {
    return (AllocationResourceStatus) super.set(fieldName, value);
  }

  @Override
  public AllocationResourceStatus clone() {
    return (AllocationResourceStatus) super.clone();
  }

}
