/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Message containing information of one individual backend.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Backend extends com.google.api.client.json.GenericJson {

  /**
   * Specifies how to determine whether the backend of a load balancer can handle additional traffic
   * or is fully loaded. For usage guidelines, see Connection balancing mode.
   *
   * Backends must use compatible balancing modes. For more information, see Supported balancing
   * modes and target capacity settings and Restrictions and guidance for instance groups.
   *
   * Note: Currently, if you use the API to configure incompatible balancing modes, the
   * configuration might be accepted even though it has no impact and is ignored. Specifically,
   * Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this
   * incompatible combination will be rejected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String balancingMode;

  /**
   * A multiplier applied to the backend's target capacity of its balancing mode. The default value
   * is 1, which means the group serves up to 100% of its configured capacity (depending
   * onbalancingMode). A setting of 0 means the group is completely drained, offering 0% of its
   * available capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot configure a setting
   * larger than 0 and smaller than0.1. You cannot configure a setting of 0 when there is only one
   * backend attached to the backend service.
   *
   * Not available with backends that don't support using abalancingMode. This includes backends
   * such as global internet NEGs, regional serverless NEGs, and PSC NEGs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float capacityScaler;

  /**
   * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<BackendCustomMetric> customMetrics;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * This field designates whether this is a failover backend. More than one failover backend can be
   * configured for a given BackendService.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean failover;

  /**
   * The fully-qualified URL of aninstance group or network endpoint group (NEG) resource. To
   * determine what types of backends a load balancer supports, see the [Backend services
   * overview](https://cloud.google.com/load-balancing/docs/backend-service#backends).
   *
   * You must use the *fully-qualified* URL (starting withhttps://www.googleapis.com/) to specify
   * the instance group or NEG. Partial URLs are not supported.
   *
   * If haPolicy is specified, backends must refer to NEG resources of type GCE_VM_IP.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String group;

  /**
   * Defines a target maximum number of simultaneous connections. For usage guidelines,
   * seeConnection balancing mode and Utilization balancing mode. Not available if the
   * backend'sbalancingMode is RATE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxConnections;

  /**
   * Defines a target maximum number of simultaneous connections.  For usage guidelines,
   * seeConnection balancing mode and Utilization balancing mode.
   *
   * Not available if the backend's balancingMode isRATE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxConnectionsPerEndpoint;

  /**
   * Defines a target maximum number of simultaneous connections. For usage guidelines,
   * seeConnection balancing mode and Utilization balancing mode.
   *
   * Not available if the backend's balancingMode isRATE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxConnectionsPerInstance;

  /**
   * Defines a maximum number of HTTP requests per second (RPS). For usage guidelines, seeRate
   * balancing mode and Utilization balancing mode.
   *
   * Not available if the backend's balancingMode isCONNECTION.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxRate;

  /**
   * Defines a maximum target for requests per second (RPS). For usage guidelines, seeRate balancing
   * mode and Utilization balancing mode.
   *
   * Not available if the backend's balancingMode isCONNECTION.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float maxRatePerEndpoint;

  /**
   * Defines a maximum target for requests per second (RPS). For usage guidelines, seeRate balancing
   * mode and Utilization balancing mode.
   *
   * Not available if the backend's balancingMode isCONNECTION.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float maxRatePerInstance;

  /**
   * Optional parameter to define a target capacity for theUTILIZATION balancing mode. The valid
   * range is[0.0, 1.0].
   *
   * For usage guidelines, seeUtilization balancing mode.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float maxUtilization;

  /**
   * This field indicates whether this backend should be fully utilized before sending traffic to
   * backends with default preference. The possible values are:        - PREFERRED: Backends with
   * this preference level will be    filled up to their capacity limits first, based on RTT.    -
   * DEFAULT:  If preferred backends don't have enough    capacity, backends in this layer would be
   * used and traffic would be    assigned based on the load balancing algorithm you use. This is
   * the    default
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String preference;

  /**
   * Specifies how to determine whether the backend of a load balancer can handle additional traffic
   * or is fully loaded. For usage guidelines, see Connection balancing mode.
   *
   * Backends must use compatible balancing modes. For more information, see Supported balancing
   * modes and target capacity settings and Restrictions and guidance for instance groups.
   *
   * Note: Currently, if you use the API to configure incompatible balancing modes, the
   * configuration might be accepted even though it has no impact and is ignored. Specifically,
   * Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this
   * incompatible combination will be rejected.
   * @return value or {@code null} for none
   */
  public java.lang.String getBalancingMode() {
    return balancingMode;
  }

  /**
   * Specifies how to determine whether the backend of a load balancer can handle additional traffic
   * or is fully loaded. For usage guidelines, see Connection balancing mode.
   *
   * Backends must use compatible balancing modes. For more information, see Supported balancing
   * modes and target capacity settings and Restrictions and guidance for instance groups.
   *
   * Note: Currently, if you use the API to configure incompatible balancing modes, the
   * configuration might be accepted even though it has no impact and is ignored. Specifically,
   * Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this
   * incompatible combination will be rejected.
   * @param balancingMode balancingMode or {@code null} for none
   */
  public Backend setBalancingMode(java.lang.String balancingMode) {
    this.balancingMode = balancingMode;
    return this;
  }

  /**
   * A multiplier applied to the backend's target capacity of its balancing mode. The default value
   * is 1, which means the group serves up to 100% of its configured capacity (depending
   * onbalancingMode). A setting of 0 means the group is completely drained, offering 0% of its
   * available capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot configure a setting
   * larger than 0 and smaller than0.1. You cannot configure a setting of 0 when there is only one
   * backend attached to the backend service.
   *
   * Not available with backends that don't support using abalancingMode. This includes backends
   * such as global internet NEGs, regional serverless NEGs, and PSC NEGs.
   * @return value or {@code null} for none
   */
  public java.lang.Float getCapacityScaler() {
    return capacityScaler;
  }

  /**
   * A multiplier applied to the backend's target capacity of its balancing mode. The default value
   * is 1, which means the group serves up to 100% of its configured capacity (depending
   * onbalancingMode). A setting of 0 means the group is completely drained, offering 0% of its
   * available capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot configure a setting
   * larger than 0 and smaller than0.1. You cannot configure a setting of 0 when there is only one
   * backend attached to the backend service.
   *
   * Not available with backends that don't support using abalancingMode. This includes backends
   * such as global internet NEGs, regional serverless NEGs, and PSC NEGs.
   * @param capacityScaler capacityScaler or {@code null} for none
   */
  public Backend setCapacityScaler(java.lang.Float capacityScaler) {
    this.capacityScaler = capacityScaler;
    return this;
  }

  /**
   * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
   * @return value or {@code null} for none
   */
  public java.util.List<BackendCustomMetric> getCustomMetrics() {
    return customMetrics;
  }

  /**
   * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
   * @param customMetrics customMetrics or {@code null} for none
   */
  public Backend setCustomMetrics(java.util.List<BackendCustomMetric> customMetrics) {
    this.customMetrics = customMetrics;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public Backend setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * This field designates whether this is a failover backend. More than one failover backend can be
   * configured for a given BackendService.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFailover() {
    return failover;
  }

  /**
   * This field designates whether this is a failover backend. More than one failover backend can be
   * configured for a given BackendService.
   * @param failover failover or {@code null} for none
   */
  public Backend setFailover(java.lang.Boolean failover) {
    this.failover = failover;
    return this;
  }

  /**
   * The fully-qualified URL of aninstance group or network endpoint group (NEG) resource. To
   * determine what types of backends a load balancer supports, see the [Backend services
   * overview](https://cloud.google.com/load-balancing/docs/backend-service#backends).
   *
   * You must use the *fully-qualified* URL (starting withhttps://www.googleapis.com/) to specify
   * the instance group or NEG. Partial URLs are not supported.
   *
   * If haPolicy is specified, backends must refer to NEG resources of type GCE_VM_IP.
   * @return value or {@code null} for none
   */
  public java.lang.String getGroup() {
    return group;
  }

  /**
   * The fully-qualified URL of aninstance group or network endpoint group (NEG) resource. To
   * determine what types of backends a load balancer supports, see the [Backend services
   * overview](https://cloud.google.com/load-balancing/docs/backend-service#backends).
   *
   * You must use the *fully-qualified* URL (starting withhttps://www.googleapis.com/) to specify
   * the instance group or NEG. Partial URLs are not supported.
   *
   * If haPolicy is specified, backends must refer to NEG resources of type GCE_VM_IP.
   * @param group group or {@code null} for none
   */
  public Backend setGroup(java.lang.String group) {
    this.group = group;
    return this;
  }

  /**
   * Defines a target maximum number of simultaneous connections. For usage guidelines,
   * seeConnection balancing mode and Utilization balancing mode. Not available if the
   * backend'sbalancingMode is RATE.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxConnections() {
    return maxConnections;
  }

  /**
   * Defines a target maximum number of simultaneous connections. For usage guidelines,
   * seeConnection balancing mode and Utilization balancing mode. Not available if the
   * backend'sbalancingMode is RATE.
   * @param maxConnections maxConnections or {@code null} for none
   */
  public Backend setMaxConnections(java.lang.Integer maxConnections) {
    this.maxConnections = maxConnections;
    return this;
  }

  /**
   * Defines a target maximum number of simultaneous connections.  For usage guidelines,
   * seeConnection balancing mode and Utilization balancing mode.
   *
   * Not available if the backend's balancingMode isRATE.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxConnectionsPerEndpoint() {
    return maxConnectionsPerEndpoint;
  }

  /**
   * Defines a target maximum number of simultaneous connections.  For usage guidelines,
   * seeConnection balancing mode and Utilization balancing mode.
   *
   * Not available if the backend's balancingMode isRATE.
   * @param maxConnectionsPerEndpoint maxConnectionsPerEndpoint or {@code null} for none
   */
  public Backend setMaxConnectionsPerEndpoint(java.lang.Integer maxConnectionsPerEndpoint) {
    this.maxConnectionsPerEndpoint = maxConnectionsPerEndpoint;
    return this;
  }

  /**
   * Defines a target maximum number of simultaneous connections. For usage guidelines,
   * seeConnection balancing mode and Utilization balancing mode.
   *
   * Not available if the backend's balancingMode isRATE.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxConnectionsPerInstance() {
    return maxConnectionsPerInstance;
  }

  /**
   * Defines a target maximum number of simultaneous connections. For usage guidelines,
   * seeConnection balancing mode and Utilization balancing mode.
   *
   * Not available if the backend's balancingMode isRATE.
   * @param maxConnectionsPerInstance maxConnectionsPerInstance or {@code null} for none
   */
  public Backend setMaxConnectionsPerInstance(java.lang.Integer maxConnectionsPerInstance) {
    this.maxConnectionsPerInstance = maxConnectionsPerInstance;
    return this;
  }

  /**
   * Defines a maximum number of HTTP requests per second (RPS). For usage guidelines, seeRate
   * balancing mode and Utilization balancing mode.
   *
   * Not available if the backend's balancingMode isCONNECTION.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxRate() {
    return maxRate;
  }

  /**
   * Defines a maximum number of HTTP requests per second (RPS). For usage guidelines, seeRate
   * balancing mode and Utilization balancing mode.
   *
   * Not available if the backend's balancingMode isCONNECTION.
   * @param maxRate maxRate or {@code null} for none
   */
  public Backend setMaxRate(java.lang.Integer maxRate) {
    this.maxRate = maxRate;
    return this;
  }

  /**
   * Defines a maximum target for requests per second (RPS). For usage guidelines, seeRate balancing
   * mode and Utilization balancing mode.
   *
   * Not available if the backend's balancingMode isCONNECTION.
   * @return value or {@code null} for none
   */
  public java.lang.Float getMaxRatePerEndpoint() {
    return maxRatePerEndpoint;
  }

  /**
   * Defines a maximum target for requests per second (RPS). For usage guidelines, seeRate balancing
   * mode and Utilization balancing mode.
   *
   * Not available if the backend's balancingMode isCONNECTION.
   * @param maxRatePerEndpoint maxRatePerEndpoint or {@code null} for none
   */
  public Backend setMaxRatePerEndpoint(java.lang.Float maxRatePerEndpoint) {
    this.maxRatePerEndpoint = maxRatePerEndpoint;
    return this;
  }

  /**
   * Defines a maximum target for requests per second (RPS). For usage guidelines, seeRate balancing
   * mode and Utilization balancing mode.
   *
   * Not available if the backend's balancingMode isCONNECTION.
   * @return value or {@code null} for none
   */
  public java.lang.Float getMaxRatePerInstance() {
    return maxRatePerInstance;
  }

  /**
   * Defines a maximum target for requests per second (RPS). For usage guidelines, seeRate balancing
   * mode and Utilization balancing mode.
   *
   * Not available if the backend's balancingMode isCONNECTION.
   * @param maxRatePerInstance maxRatePerInstance or {@code null} for none
   */
  public Backend setMaxRatePerInstance(java.lang.Float maxRatePerInstance) {
    this.maxRatePerInstance = maxRatePerInstance;
    return this;
  }

  /**
   * Optional parameter to define a target capacity for theUTILIZATION balancing mode. The valid
   * range is[0.0, 1.0].
   *
   * For usage guidelines, seeUtilization balancing mode.
   * @return value or {@code null} for none
   */
  public java.lang.Float getMaxUtilization() {
    return maxUtilization;
  }

  /**
   * Optional parameter to define a target capacity for theUTILIZATION balancing mode. The valid
   * range is[0.0, 1.0].
   *
   * For usage guidelines, seeUtilization balancing mode.
   * @param maxUtilization maxUtilization or {@code null} for none
   */
  public Backend setMaxUtilization(java.lang.Float maxUtilization) {
    this.maxUtilization = maxUtilization;
    return this;
  }

  /**
   * This field indicates whether this backend should be fully utilized before sending traffic to
   * backends with default preference. The possible values are:        - PREFERRED: Backends with
   * this preference level will be    filled up to their capacity limits first, based on RTT.    -
   * DEFAULT:  If preferred backends don't have enough    capacity, backends in this layer would be
   * used and traffic would be    assigned based on the load balancing algorithm you use. This is
   * the    default
   * @return value or {@code null} for none
   */
  public java.lang.String getPreference() {
    return preference;
  }

  /**
   * This field indicates whether this backend should be fully utilized before sending traffic to
   * backends with default preference. The possible values are:        - PREFERRED: Backends with
   * this preference level will be    filled up to their capacity limits first, based on RTT.    -
   * DEFAULT:  If preferred backends don't have enough    capacity, backends in this layer would be
   * used and traffic would be    assigned based on the load balancing algorithm you use. This is
   * the    default
   * @param preference preference or {@code null} for none
   */
  public Backend setPreference(java.lang.String preference) {
    this.preference = preference;
    return this;
  }

  @Override
  public Backend set(String fieldName, Object value) {
    return (Backend) super.set(fieldName, value);
  }

  @Override
  public Backend clone() {
    return (Backend) super.clone();
  }

}
