/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a regional resource-based commitment resource.
 *
 * Creating this commitment resource means that you are purchasing a resource-based committed use
 * contract, with an explicit start and end time. You can purchase resource-based commitments for
 * both hardware and software resources. For more information, read Resource-based committed use
 * discounts
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Commitment extends com.google.api.client.json.GenericJson {

  /**
   * Specifies whether to automatically renew the commitment at the end of its current term. The
   * default value is false. If you set the field to true, each time your commitment reaches the end
   * of its term, Compute Engine automatically renews it for another term. You can update this field
   * anytime before the commitment expires. For example, if the commitment is set to expire at 12 AM
   * UTC-8 on January 3, 2027, you can update this field until 11:59 PM UTC-8 on January 2, 2027.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean autoRenew;

  /**
   * The category of the commitment; specifies whether the commitment is for hardware or software
   * resources. Category MACHINE specifies that you are committing to hardware machine resources
   * such asVCPU or MEMORY, listed in resources. Category LICENSE specifies that you are committing
   * to software licenses, listed in licenseResources. Note that if you specify MACHINE commitments,
   * then you must also specify a type to indicate the machine series of the hardware resource that
   * you are committing to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String category;

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * [Input Only] Optional, specifies the requested commitment end time inRFC3339 text format. Use
   * this option when the desired commitment's end date is later than the start date + term
   * duration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customEndTimestamp;

  /**
   * An optional description of the commitment. You can provide this property when you create the
   * resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] Commitment end time inRFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String endTimestamp;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> existingReservations;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] Type of the resource. Always compute#commitment for commitments.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The license specification required as part of a license commitment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LicenseResourceCommitment licenseResource;

  /**
   * The list of source commitments that you are merging to create the new merged commitment. For
   * more information, see Merging commitments.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> mergeSourceCommitments;

  /**
   * Name of the commitment. You must specify a name when you purchase the commitment. The name must
   * be 1-63 characters long, and comply withRFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The minimum time duration that you commit to purchasing resources. The plan that you choose
   * determines the preset term length of the commitment (which is 1 year or 3 years) and affects
   * the discount rate that you receive for your resources. Committing to a longer time duration
   * typically gives you a higher discount rate. The supported values for this field are
   * TWELVE_MONTH (1 year), andTHIRTY_SIX_MONTH (3 years).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String plan;

  /**
   * [Output Only] URL of the region where the commitment and committed resources are located.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * The list of new reservations that you want to create and attach to this commitment.
   *
   * You must attach reservations to your commitment if your commitment specifies any GPUs or Local
   * SSD disks. For more information, see  Attach reservations to resource-based commitments.
   *
   * Specify this property only if you want to create new reservations to attach. To attach existing
   * reservations, specify theexistingReservations property instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Reservation> reservations;

  /**
   * [Output Only] Status information for Commitment resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CommitmentResourceStatus resourceStatus;

  /**
   * The list of all the hardware resources, with their types and amounts, that you want to commit
   * to. Specify as a separate entry in the list for each individual resource type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ResourceCommitment> resources;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The source commitment from which you are transferring resources to create the new split
   * commitment. For more information, see  Split commitments.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String splitSourceCommitment;

  /**
   * [Output Only] Commitment start time inRFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String startTimestamp;

  /**
   * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has
   * an end date defined). Status can be one of the following values: NOT_YET_ACTIVE, ACTIVE,
   * orEXPIRED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * [Output Only] An optional, human-readable explanation of the status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String statusMessage;

  /**
   * The type of commitment; specifies the machine series for which you want to commit to purchasing
   * resources. The choice of machine series affects the discount rate and the eligible resource
   * types.
   *
   *  The type must be one of the following:ACCELERATOR_OPTIMIZED,
   * ACCELERATOR_OPTIMIZED_A3,ACCELERATOR_OPTIMIZED_A3_MEGA,COMPUTE_OPTIMIZED,
   * COMPUTE_OPTIMIZED_C2D,  COMPUTE_OPTIMIZED_C3, COMPUTE_OPTIMIZED_C3D,COMPUTE_OPTIMIZED_H3,
   * GENERAL_PURPOSE,GENERAL_PURPOSE_C4, GENERAL_PURPOSE_E2,GENERAL_PURPOSE_N2,
   * GENERAL_PURPOSE_N2D,GENERAL_PURPOSE_N4, GENERAL_PURPOSE_T2D,GRAPHICS_OPTIMIZED,
   * GRAPHICS_OPTIMIZED_G4,MEMORY_OPTIMIZED, MEMORY_OPTIMIZED_M3,MEMORY_OPTIMIZED_X4,
   * STORAGE_OPTIMIZED_Z3. For example, type MEMORY_OPTIMIZED specifies a commitment that applies
   * only to eligible resources of memory optimized M1 and M2 machine series. Type GENERAL_PURPOSE
   * specifies a commitment that applies only to eligible resources of general purpose N1 machine
   * series.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Specifies whether to automatically renew the commitment at the end of its current term. The
   * default value is false. If you set the field to true, each time your commitment reaches the end
   * of its term, Compute Engine automatically renews it for another term. You can update this field
   * anytime before the commitment expires. For example, if the commitment is set to expire at 12 AM
   * UTC-8 on January 3, 2027, you can update this field until 11:59 PM UTC-8 on January 2, 2027.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutoRenew() {
    return autoRenew;
  }

  /**
   * Specifies whether to automatically renew the commitment at the end of its current term. The
   * default value is false. If you set the field to true, each time your commitment reaches the end
   * of its term, Compute Engine automatically renews it for another term. You can update this field
   * anytime before the commitment expires. For example, if the commitment is set to expire at 12 AM
   * UTC-8 on January 3, 2027, you can update this field until 11:59 PM UTC-8 on January 2, 2027.
   * @param autoRenew autoRenew or {@code null} for none
   */
  public Commitment setAutoRenew(java.lang.Boolean autoRenew) {
    this.autoRenew = autoRenew;
    return this;
  }

  /**
   * The category of the commitment; specifies whether the commitment is for hardware or software
   * resources. Category MACHINE specifies that you are committing to hardware machine resources
   * such asVCPU or MEMORY, listed in resources. Category LICENSE specifies that you are committing
   * to software licenses, listed in licenseResources. Note that if you specify MACHINE commitments,
   * then you must also specify a type to indicate the machine series of the hardware resource that
   * you are committing to.
   * @return value or {@code null} for none
   */
  public java.lang.String getCategory() {
    return category;
  }

  /**
   * The category of the commitment; specifies whether the commitment is for hardware or software
   * resources. Category MACHINE specifies that you are committing to hardware machine resources
   * such asVCPU or MEMORY, listed in resources. Category LICENSE specifies that you are committing
   * to software licenses, listed in licenseResources. Note that if you specify MACHINE commitments,
   * then you must also specify a type to indicate the machine series of the hardware resource that
   * you are committing to.
   * @param category category or {@code null} for none
   */
  public Commitment setCategory(java.lang.String category) {
    this.category = category;
    return this;
  }

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public Commitment setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * [Input Only] Optional, specifies the requested commitment end time inRFC3339 text format. Use
   * this option when the desired commitment's end date is later than the start date + term
   * duration.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomEndTimestamp() {
    return customEndTimestamp;
  }

  /**
   * [Input Only] Optional, specifies the requested commitment end time inRFC3339 text format. Use
   * this option when the desired commitment's end date is later than the start date + term
   * duration.
   * @param customEndTimestamp customEndTimestamp or {@code null} for none
   */
  public Commitment setCustomEndTimestamp(java.lang.String customEndTimestamp) {
    this.customEndTimestamp = customEndTimestamp;
    return this;
  }

  /**
   * An optional description of the commitment. You can provide this property when you create the
   * resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of the commitment. You can provide this property when you create the
   * resource.
   * @param description description or {@code null} for none
   */
  public Commitment setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] Commitment end time inRFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getEndTimestamp() {
    return endTimestamp;
  }

  /**
   * [Output Only] Commitment end time inRFC3339 text format.
   * @param endTimestamp endTimestamp or {@code null} for none
   */
  public Commitment setEndTimestamp(java.lang.String endTimestamp) {
    this.endTimestamp = endTimestamp;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getExistingReservations() {
    return existingReservations;
  }

  /**
   * @param existingReservations existingReservations or {@code null} for none
   */
  public Commitment setExistingReservations(java.util.List<java.lang.String> existingReservations) {
    this.existingReservations = existingReservations;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public Commitment setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#commitment for commitments.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#commitment for commitments.
   * @param kind kind or {@code null} for none
   */
  public Commitment setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The license specification required as part of a license commitment.
   * @return value or {@code null} for none
   */
  public LicenseResourceCommitment getLicenseResource() {
    return licenseResource;
  }

  /**
   * The license specification required as part of a license commitment.
   * @param licenseResource licenseResource or {@code null} for none
   */
  public Commitment setLicenseResource(LicenseResourceCommitment licenseResource) {
    this.licenseResource = licenseResource;
    return this;
  }

  /**
   * The list of source commitments that you are merging to create the new merged commitment. For
   * more information, see Merging commitments.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getMergeSourceCommitments() {
    return mergeSourceCommitments;
  }

  /**
   * The list of source commitments that you are merging to create the new merged commitment. For
   * more information, see Merging commitments.
   * @param mergeSourceCommitments mergeSourceCommitments or {@code null} for none
   */
  public Commitment setMergeSourceCommitments(java.util.List<java.lang.String> mergeSourceCommitments) {
    this.mergeSourceCommitments = mergeSourceCommitments;
    return this;
  }

  /**
   * Name of the commitment. You must specify a name when you purchase the commitment. The name must
   * be 1-63 characters long, and comply withRFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the commitment. You must specify a name when you purchase the commitment. The name must
   * be 1-63 characters long, and comply withRFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public Commitment setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The minimum time duration that you commit to purchasing resources. The plan that you choose
   * determines the preset term length of the commitment (which is 1 year or 3 years) and affects
   * the discount rate that you receive for your resources. Committing to a longer time duration
   * typically gives you a higher discount rate. The supported values for this field are
   * TWELVE_MONTH (1 year), andTHIRTY_SIX_MONTH (3 years).
   * @return value or {@code null} for none
   */
  public java.lang.String getPlan() {
    return plan;
  }

  /**
   * The minimum time duration that you commit to purchasing resources. The plan that you choose
   * determines the preset term length of the commitment (which is 1 year or 3 years) and affects
   * the discount rate that you receive for your resources. Committing to a longer time duration
   * typically gives you a higher discount rate. The supported values for this field are
   * TWELVE_MONTH (1 year), andTHIRTY_SIX_MONTH (3 years).
   * @param plan plan or {@code null} for none
   */
  public Commitment setPlan(java.lang.String plan) {
    this.plan = plan;
    return this;
  }

  /**
   * [Output Only] URL of the region where the commitment and committed resources are located.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * [Output Only] URL of the region where the commitment and committed resources are located.
   * @param region region or {@code null} for none
   */
  public Commitment setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * The list of new reservations that you want to create and attach to this commitment.
   *
   * You must attach reservations to your commitment if your commitment specifies any GPUs or Local
   * SSD disks. For more information, see  Attach reservations to resource-based commitments.
   *
   * Specify this property only if you want to create new reservations to attach. To attach existing
   * reservations, specify theexistingReservations property instead.
   * @return value or {@code null} for none
   */
  public java.util.List<Reservation> getReservations() {
    return reservations;
  }

  /**
   * The list of new reservations that you want to create and attach to this commitment.
   *
   * You must attach reservations to your commitment if your commitment specifies any GPUs or Local
   * SSD disks. For more information, see  Attach reservations to resource-based commitments.
   *
   * Specify this property only if you want to create new reservations to attach. To attach existing
   * reservations, specify theexistingReservations property instead.
   * @param reservations reservations or {@code null} for none
   */
  public Commitment setReservations(java.util.List<Reservation> reservations) {
    this.reservations = reservations;
    return this;
  }

  /**
   * [Output Only] Status information for Commitment resource.
   * @return value or {@code null} for none
   */
  public CommitmentResourceStatus getResourceStatus() {
    return resourceStatus;
  }

  /**
   * [Output Only] Status information for Commitment resource.
   * @param resourceStatus resourceStatus or {@code null} for none
   */
  public Commitment setResourceStatus(CommitmentResourceStatus resourceStatus) {
    this.resourceStatus = resourceStatus;
    return this;
  }

  /**
   * The list of all the hardware resources, with their types and amounts, that you want to commit
   * to. Specify as a separate entry in the list for each individual resource type.
   * @return value or {@code null} for none
   */
  public java.util.List<ResourceCommitment> getResources() {
    return resources;
  }

  /**
   * The list of all the hardware resources, with their types and amounts, that you want to commit
   * to. Specify as a separate entry in the list for each individual resource type.
   * @param resources resources or {@code null} for none
   */
  public Commitment setResources(java.util.List<ResourceCommitment> resources) {
    this.resources = resources;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public Commitment setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The source commitment from which you are transferring resources to create the new split
   * commitment. For more information, see  Split commitments.
   * @return value or {@code null} for none
   */
  public java.lang.String getSplitSourceCommitment() {
    return splitSourceCommitment;
  }

  /**
   * The source commitment from which you are transferring resources to create the new split
   * commitment. For more information, see  Split commitments.
   * @param splitSourceCommitment splitSourceCommitment or {@code null} for none
   */
  public Commitment setSplitSourceCommitment(java.lang.String splitSourceCommitment) {
    this.splitSourceCommitment = splitSourceCommitment;
    return this;
  }

  /**
   * [Output Only] Commitment start time inRFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getStartTimestamp() {
    return startTimestamp;
  }

  /**
   * [Output Only] Commitment start time inRFC3339 text format.
   * @param startTimestamp startTimestamp or {@code null} for none
   */
  public Commitment setStartTimestamp(java.lang.String startTimestamp) {
    this.startTimestamp = startTimestamp;
    return this;
  }

  /**
   * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has
   * an end date defined). Status can be one of the following values: NOT_YET_ACTIVE, ACTIVE,
   * orEXPIRED.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has
   * an end date defined). Status can be one of the following values: NOT_YET_ACTIVE, ACTIVE,
   * orEXPIRED.
   * @param status status or {@code null} for none
   */
  public Commitment setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * [Output Only] An optional, human-readable explanation of the status.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatusMessage() {
    return statusMessage;
  }

  /**
   * [Output Only] An optional, human-readable explanation of the status.
   * @param statusMessage statusMessage or {@code null} for none
   */
  public Commitment setStatusMessage(java.lang.String statusMessage) {
    this.statusMessage = statusMessage;
    return this;
  }

  /**
   * The type of commitment; specifies the machine series for which you want to commit to purchasing
   * resources. The choice of machine series affects the discount rate and the eligible resource
   * types.
   *
   *  The type must be one of the following:ACCELERATOR_OPTIMIZED,
   * ACCELERATOR_OPTIMIZED_A3,ACCELERATOR_OPTIMIZED_A3_MEGA,COMPUTE_OPTIMIZED,
   * COMPUTE_OPTIMIZED_C2D,  COMPUTE_OPTIMIZED_C3, COMPUTE_OPTIMIZED_C3D,COMPUTE_OPTIMIZED_H3,
   * GENERAL_PURPOSE,GENERAL_PURPOSE_C4, GENERAL_PURPOSE_E2,GENERAL_PURPOSE_N2,
   * GENERAL_PURPOSE_N2D,GENERAL_PURPOSE_N4, GENERAL_PURPOSE_T2D,GRAPHICS_OPTIMIZED,
   * GRAPHICS_OPTIMIZED_G4,MEMORY_OPTIMIZED, MEMORY_OPTIMIZED_M3,MEMORY_OPTIMIZED_X4,
   * STORAGE_OPTIMIZED_Z3. For example, type MEMORY_OPTIMIZED specifies a commitment that applies
   * only to eligible resources of memory optimized M1 and M2 machine series. Type GENERAL_PURPOSE
   * specifies a commitment that applies only to eligible resources of general purpose N1 machine
   * series.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of commitment; specifies the machine series for which you want to commit to purchasing
   * resources. The choice of machine series affects the discount rate and the eligible resource
   * types.
   *
   *  The type must be one of the following:ACCELERATOR_OPTIMIZED,
   * ACCELERATOR_OPTIMIZED_A3,ACCELERATOR_OPTIMIZED_A3_MEGA,COMPUTE_OPTIMIZED,
   * COMPUTE_OPTIMIZED_C2D,  COMPUTE_OPTIMIZED_C3, COMPUTE_OPTIMIZED_C3D,COMPUTE_OPTIMIZED_H3,
   * GENERAL_PURPOSE,GENERAL_PURPOSE_C4, GENERAL_PURPOSE_E2,GENERAL_PURPOSE_N2,
   * GENERAL_PURPOSE_N2D,GENERAL_PURPOSE_N4, GENERAL_PURPOSE_T2D,GRAPHICS_OPTIMIZED,
   * GRAPHICS_OPTIMIZED_G4,MEMORY_OPTIMIZED, MEMORY_OPTIMIZED_M3,MEMORY_OPTIMIZED_X4,
   * STORAGE_OPTIMIZED_Z3. For example, type MEMORY_OPTIMIZED specifies a commitment that applies
   * only to eligible resources of memory optimized M1 and M2 machine series. Type GENERAL_PURPOSE
   * specifies a commitment that applies only to eligible resources of general purpose N1 machine
   * series.
   * @param type type or {@code null} for none
   */
  public Commitment setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Commitment set(String fieldName, Object value) {
    return (Commitment) super.set(fieldName, value);
  }

  @Override
  public Commitment clone() {
    return (Commitment) super.clone();
  }

}
