/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for DistributionPolicy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DistributionPolicy extends com.google.api.client.json.GenericJson {

  /**
   * The distribution shape to which the group converges either proactively or on resize events
   * (depending on the value set inupdatePolicy.instanceRedistributionType).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetShape;

  /**
   * Zones where the regional managed instance group will create and manage its instances.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DistributionPolicyZoneConfiguration> zones;

  /**
   * The distribution shape to which the group converges either proactively or on resize events
   * (depending on the value set inupdatePolicy.instanceRedistributionType).
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetShape() {
    return targetShape;
  }

  /**
   * The distribution shape to which the group converges either proactively or on resize events
   * (depending on the value set inupdatePolicy.instanceRedistributionType).
   * @param targetShape targetShape or {@code null} for none
   */
  public DistributionPolicy setTargetShape(java.lang.String targetShape) {
    this.targetShape = targetShape;
    return this;
  }

  /**
   * Zones where the regional managed instance group will create and manage its instances.
   * @return value or {@code null} for none
   */
  public java.util.List<DistributionPolicyZoneConfiguration> getZones() {
    return zones;
  }

  /**
   * Zones where the regional managed instance group will create and manage its instances.
   * @param zones zones or {@code null} for none
   */
  public DistributionPolicy setZones(java.util.List<DistributionPolicyZoneConfiguration> zones) {
    this.zones = zones;
    return this;
  }

  @Override
  public DistributionPolicy set(String fieldName, Object value) {
    return (DistributionPolicy) super.set(fieldName, value);
  }

  @Override
  public DistributionPolicy clone() {
    return (DistributionPolicy) super.clone();
  }

}
