/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * L2 Interconnect Attachment related configuration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectAttachmentL2Forwarding extends com.google.api.client.json.GenericJson {

  /**
   * Optional. A map of VLAN tags to appliances and optional inner mapping rules. If VLANs are not
   * explicitly mapped to any appliance, the defaultApplianceIpAddress is used.
   *
   * Each VLAN tag can be a single number or a range of numbers in the range of 1 to 4094, e.g., "1"
   * or "4001-4094". Non-empty and non-overlapping VLAN tag ranges are enforced, and violating
   * operations will be rejected.
   *
   * The VLAN tags in the Ethernet header must use an ethertype value of 0x88A8 or 0x8100.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, InterconnectAttachmentL2ForwardingApplianceMapping> applianceMappings;

  /**
   * Optional. A single IPv4 or IPv6 address used as the default destination IP when there is no
   * VLAN mapping result found.
   *
   * Unset field (null-value) indicates the unmatched packet should be dropped.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultApplianceIpAddress;

  /**
   * Optional. It represents the structure of a Geneve (Generic Network Virtualization
   * Encapsulation) header, as defined in RFC8926. It encapsulates packets from various protocols
   * (e.g., Ethernet, IPv4, IPv6) for use in network virtualization environments.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectAttachmentL2ForwardingGeneveHeader geneveHeader;

  /**
   * Required. Resource URL of the network to which this attachment belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String network;

  /**
   * Required. A single IPv4 or IPv6 address. This address will be used as the source IP address for
   * packets sent to the appliances, and must be used as the destination IP address for packets that
   * should be sent out through this attachment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tunnelEndpointIpAddress;

  /**
   * Optional. A map of VLAN tags to appliances and optional inner mapping rules. If VLANs are not
   * explicitly mapped to any appliance, the defaultApplianceIpAddress is used.
   *
   * Each VLAN tag can be a single number or a range of numbers in the range of 1 to 4094, e.g., "1"
   * or "4001-4094". Non-empty and non-overlapping VLAN tag ranges are enforced, and violating
   * operations will be rejected.
   *
   * The VLAN tags in the Ethernet header must use an ethertype value of 0x88A8 or 0x8100.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, InterconnectAttachmentL2ForwardingApplianceMapping> getApplianceMappings() {
    return applianceMappings;
  }

  /**
   * Optional. A map of VLAN tags to appliances and optional inner mapping rules. If VLANs are not
   * explicitly mapped to any appliance, the defaultApplianceIpAddress is used.
   *
   * Each VLAN tag can be a single number or a range of numbers in the range of 1 to 4094, e.g., "1"
   * or "4001-4094". Non-empty and non-overlapping VLAN tag ranges are enforced, and violating
   * operations will be rejected.
   *
   * The VLAN tags in the Ethernet header must use an ethertype value of 0x88A8 or 0x8100.
   * @param applianceMappings applianceMappings or {@code null} for none
   */
  public InterconnectAttachmentL2Forwarding setApplianceMappings(java.util.Map<String, InterconnectAttachmentL2ForwardingApplianceMapping> applianceMappings) {
    this.applianceMappings = applianceMappings;
    return this;
  }

  /**
   * Optional. A single IPv4 or IPv6 address used as the default destination IP when there is no
   * VLAN mapping result found.
   *
   * Unset field (null-value) indicates the unmatched packet should be dropped.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultApplianceIpAddress() {
    return defaultApplianceIpAddress;
  }

  /**
   * Optional. A single IPv4 or IPv6 address used as the default destination IP when there is no
   * VLAN mapping result found.
   *
   * Unset field (null-value) indicates the unmatched packet should be dropped.
   * @param defaultApplianceIpAddress defaultApplianceIpAddress or {@code null} for none
   */
  public InterconnectAttachmentL2Forwarding setDefaultApplianceIpAddress(java.lang.String defaultApplianceIpAddress) {
    this.defaultApplianceIpAddress = defaultApplianceIpAddress;
    return this;
  }

  /**
   * Optional. It represents the structure of a Geneve (Generic Network Virtualization
   * Encapsulation) header, as defined in RFC8926. It encapsulates packets from various protocols
   * (e.g., Ethernet, IPv4, IPv6) for use in network virtualization environments.
   * @return value or {@code null} for none
   */
  public InterconnectAttachmentL2ForwardingGeneveHeader getGeneveHeader() {
    return geneveHeader;
  }

  /**
   * Optional. It represents the structure of a Geneve (Generic Network Virtualization
   * Encapsulation) header, as defined in RFC8926. It encapsulates packets from various protocols
   * (e.g., Ethernet, IPv4, IPv6) for use in network virtualization environments.
   * @param geneveHeader geneveHeader or {@code null} for none
   */
  public InterconnectAttachmentL2Forwarding setGeneveHeader(InterconnectAttachmentL2ForwardingGeneveHeader geneveHeader) {
    this.geneveHeader = geneveHeader;
    return this;
  }

  /**
   * Required. Resource URL of the network to which this attachment belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getNetwork() {
    return network;
  }

  /**
   * Required. Resource URL of the network to which this attachment belongs.
   * @param network network or {@code null} for none
   */
  public InterconnectAttachmentL2Forwarding setNetwork(java.lang.String network) {
    this.network = network;
    return this;
  }

  /**
   * Required. A single IPv4 or IPv6 address. This address will be used as the source IP address for
   * packets sent to the appliances, and must be used as the destination IP address for packets that
   * should be sent out through this attachment.
   * @return value or {@code null} for none
   */
  public java.lang.String getTunnelEndpointIpAddress() {
    return tunnelEndpointIpAddress;
  }

  /**
   * Required. A single IPv4 or IPv6 address. This address will be used as the source IP address for
   * packets sent to the appliances, and must be used as the destination IP address for packets that
   * should be sent out through this attachment.
   * @param tunnelEndpointIpAddress tunnelEndpointIpAddress or {@code null} for none
   */
  public InterconnectAttachmentL2Forwarding setTunnelEndpointIpAddress(java.lang.String tunnelEndpointIpAddress) {
    this.tunnelEndpointIpAddress = tunnelEndpointIpAddress;
    return this;
  }

  @Override
  public InterconnectAttachmentL2Forwarding set(String fieldName, Object value) {
    return (InterconnectAttachmentL2Forwarding) super.set(fieldName, value);
  }

  @Override
  public InterconnectAttachmentL2Forwarding clone() {
    return (InterconnectAttachmentL2Forwarding) super.clone();
  }

}
