/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Describes a pre-shared key used to setup MACsec in static connectivity association key (CAK)
 * mode.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectMacsecPreSharedKey extends com.google.api.client.json.GenericJson {

  /**
   * Required. A name for this pre-shared key. The name must be 1-63 characters long, and comply
   * withRFC1035. Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase
   * letter, and all following characters must be a dash, lowercase letter, or digit, except the
   * last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * A RFC3339 timestamp on or after which the key is valid. startTime can be in the future. If the
   * keychain has a single key, startTime can be omitted. If the keychain has multiple keys,
   * startTime is mandatory for each key. The start times of keys must be in increasing order. The
   * start times of two consecutive keys must be at least 6 hours apart.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String startTime;

  /**
   * Required. A name for this pre-shared key. The name must be 1-63 characters long, and comply
   * withRFC1035. Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase
   * letter, and all following characters must be a dash, lowercase letter, or digit, except the
   * last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Required. A name for this pre-shared key. The name must be 1-63 characters long, and comply
   * withRFC1035. Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase
   * letter, and all following characters must be a dash, lowercase letter, or digit, except the
   * last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public InterconnectMacsecPreSharedKey setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * A RFC3339 timestamp on or after which the key is valid. startTime can be in the future. If the
   * keychain has a single key, startTime can be omitted. If the keychain has multiple keys,
   * startTime is mandatory for each key. The start times of keys must be in increasing order. The
   * start times of two consecutive keys must be at least 6 hours apart.
   * @return value or {@code null} for none
   */
  public java.lang.String getStartTime() {
    return startTime;
  }

  /**
   * A RFC3339 timestamp on or after which the key is valid. startTime can be in the future. If the
   * keychain has a single key, startTime can be omitted. If the keychain has multiple keys,
   * startTime is mandatory for each key. The start times of keys must be in increasing order. The
   * start times of two consecutive keys must be at least 6 hours apart.
   * @param startTime startTime or {@code null} for none
   */
  public InterconnectMacsecPreSharedKey setStartTime(java.lang.String startTime) {
    this.startTime = startTime;
    return this;
  }

  @Override
  public InterconnectMacsecPreSharedKey set(String fieldName, Object value) {
    return (InterconnectMacsecPreSharedKey) super.set(fieldName, value);
  }

  @Override
  public InterconnectMacsecPreSharedKey clone() {
    return (InterconnectMacsecPreSharedKey) super.clone();
  }

}
