/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * [Output Only] A connection connected to this network attachment.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkAttachmentConnectedEndpoint extends com.google.api.client.json.GenericJson {

  /**
   * The IPv4 address assigned to the producer instance network interface. This value will be a
   * range in case of Serverless.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipAddress;

  /**
   * The IPv6 address assigned to the producer instance network interface. This is only assigned
   * when the stack types of both the instance network interface and the consumer subnet are
   * IPv4_IPv6.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipv6Address;

  /**
   * The project id or number of the interface to which the IP was assigned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectIdOrNum;

  /**
   * Alias IP ranges from the same subnetwork.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> secondaryIpCidrRanges;

  /**
   * The status of a connected endpoint to this network attachment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * The subnetwork used to assign the IP to the producer instance network interface.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subnetwork;

  /**
   * [Output Only] The CIDR range of the subnet from which the IPv4 internal IP was allocated from.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subnetworkCidrRange;

  /**
   * The IPv4 address assigned to the producer instance network interface. This value will be a
   * range in case of Serverless.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpAddress() {
    return ipAddress;
  }

  /**
   * The IPv4 address assigned to the producer instance network interface. This value will be a
   * range in case of Serverless.
   * @param ipAddress ipAddress or {@code null} for none
   */
  public NetworkAttachmentConnectedEndpoint setIpAddress(java.lang.String ipAddress) {
    this.ipAddress = ipAddress;
    return this;
  }

  /**
   * The IPv6 address assigned to the producer instance network interface. This is only assigned
   * when the stack types of both the instance network interface and the consumer subnet are
   * IPv4_IPv6.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpv6Address() {
    return ipv6Address;
  }

  /**
   * The IPv6 address assigned to the producer instance network interface. This is only assigned
   * when the stack types of both the instance network interface and the consumer subnet are
   * IPv4_IPv6.
   * @param ipv6Address ipv6Address or {@code null} for none
   */
  public NetworkAttachmentConnectedEndpoint setIpv6Address(java.lang.String ipv6Address) {
    this.ipv6Address = ipv6Address;
    return this;
  }

  /**
   * The project id or number of the interface to which the IP was assigned.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectIdOrNum() {
    return projectIdOrNum;
  }

  /**
   * The project id or number of the interface to which the IP was assigned.
   * @param projectIdOrNum projectIdOrNum or {@code null} for none
   */
  public NetworkAttachmentConnectedEndpoint setProjectIdOrNum(java.lang.String projectIdOrNum) {
    this.projectIdOrNum = projectIdOrNum;
    return this;
  }

  /**
   * Alias IP ranges from the same subnetwork.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSecondaryIpCidrRanges() {
    return secondaryIpCidrRanges;
  }

  /**
   * Alias IP ranges from the same subnetwork.
   * @param secondaryIpCidrRanges secondaryIpCidrRanges or {@code null} for none
   */
  public NetworkAttachmentConnectedEndpoint setSecondaryIpCidrRanges(java.util.List<java.lang.String> secondaryIpCidrRanges) {
    this.secondaryIpCidrRanges = secondaryIpCidrRanges;
    return this;
  }

  /**
   * The status of a connected endpoint to this network attachment.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * The status of a connected endpoint to this network attachment.
   * @param status status or {@code null} for none
   */
  public NetworkAttachmentConnectedEndpoint setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * The subnetwork used to assign the IP to the producer instance network interface.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubnetwork() {
    return subnetwork;
  }

  /**
   * The subnetwork used to assign the IP to the producer instance network interface.
   * @param subnetwork subnetwork or {@code null} for none
   */
  public NetworkAttachmentConnectedEndpoint setSubnetwork(java.lang.String subnetwork) {
    this.subnetwork = subnetwork;
    return this;
  }

  /**
   * [Output Only] The CIDR range of the subnet from which the IPv4 internal IP was allocated from.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubnetworkCidrRange() {
    return subnetworkCidrRange;
  }

  /**
   * [Output Only] The CIDR range of the subnet from which the IPv4 internal IP was allocated from.
   * @param subnetworkCidrRange subnetworkCidrRange or {@code null} for none
   */
  public NetworkAttachmentConnectedEndpoint setSubnetworkCidrRange(java.lang.String subnetworkCidrRange) {
    this.subnetworkCidrRange = subnetworkCidrRange;
    return this;
  }

  @Override
  public NetworkAttachmentConnectedEndpoint set(String fieldName, Object value) {
    return (NetworkAttachmentConnectedEndpoint) super.set(fieldName, value);
  }

  @Override
  public NetworkAttachmentConnectedEndpoint clone() {
    return (NetworkAttachmentConnectedEndpoint) super.clone();
  }

}
