/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Reservation consumption information that the instance is consuming from.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourceStatusReservationConsumptionInfo extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The full resource name of the reservation that this instance is consuming from.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String consumedReservation;

  /**
   * [Output Only] The full resource name of the reservation that this instance is consuming from.
   * @return value or {@code null} for none
   */
  public java.lang.String getConsumedReservation() {
    return consumedReservation;
  }

  /**
   * [Output Only] The full resource name of the reservation that this instance is consuming from.
   * @param consumedReservation consumedReservation or {@code null} for none
   */
  public ResourceStatusReservationConsumptionInfo setConsumedReservation(java.lang.String consumedReservation) {
    this.consumedReservation = consumedReservation;
    return this;
  }

  @Override
  public ResourceStatusReservationConsumptionInfo set(String fieldName, Object value) {
    return (ResourceStatusReservationConsumptionInfo) super.set(fieldName, value);
  }

  @Override
  public ResourceStatusReservationConsumptionInfo clone() {
    return (ResourceStatusReservationConsumptionInfo) super.clone();
  }

}
