/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Configuration of logging on a NAT.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RouterNatLogConfig extends com.google.api.client.json.GenericJson {

  /**
   * Indicates whether or not to export logs. This is false by default.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enable;

  /**
   * Specify the desired filtering of logs on this NAT. If unspecified, logs are exported for all
   * connections handled by this NAT. This option can take one of the following values:        -
   * ERRORS_ONLY: Export logs only for connection failures.    - TRANSLATIONS_ONLY: Export logs only
   * for successful    connections.    - ALL: Export logs for all connections, successful and
   * unsuccessful.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String filter;

  /**
   * Indicates whether or not to export logs. This is false by default.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnable() {
    return enable;
  }

  /**
   * Indicates whether or not to export logs. This is false by default.
   * @param enable enable or {@code null} for none
   */
  public RouterNatLogConfig setEnable(java.lang.Boolean enable) {
    this.enable = enable;
    return this;
  }

  /**
   * Specify the desired filtering of logs on this NAT. If unspecified, logs are exported for all
   * connections handled by this NAT. This option can take one of the following values:        -
   * ERRORS_ONLY: Export logs only for connection failures.    - TRANSLATIONS_ONLY: Export logs only
   * for successful    connections.    - ALL: Export logs for all connections, successful and
   * unsuccessful.
   * @return value or {@code null} for none
   */
  public java.lang.String getFilter() {
    return filter;
  }

  /**
   * Specify the desired filtering of logs on this NAT. If unspecified, logs are exported for all
   * connections handled by this NAT. This option can take one of the following values:        -
   * ERRORS_ONLY: Export logs only for connection failures.    - TRANSLATIONS_ONLY: Export logs only
   * for successful    connections.    - ALL: Export logs for all connections, successful and
   * unsuccessful.
   * @param filter filter or {@code null} for none
   */
  public RouterNatLogConfig setFilter(java.lang.String filter) {
    this.filter = filter;
    return this;
  }

  @Override
  public RouterNatLogConfig set(String fieldName, Object value) {
    return (RouterNatLogConfig) super.set(fieldName, value);
  }

  @Override
  public RouterNatLogConfig clone() {
    return (RouterNatLogConfig) super.clone();
  }

}
