/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Additional snapshot params.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SnapshotParams extends com.google.api.client.json.GenericJson {

  /**
   * Resource manager tags to be bound to the snapshot. Tag keys and values have the same definition
   * as resource manager tags. Keys and values can be either in numeric format, such as
   * `tagKeys/{tag_key_id}` and `tagValues/456` or in namespaced format such as
   * `{org_id|project_id}/{tag_key_short_name}` and `{tag_value_short_name}`. The field is ignored
   * (both PUT & PATCH) when empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> resourceManagerTags;

  /**
   * Resource manager tags to be bound to the snapshot. Tag keys and values have the same definition
   * as resource manager tags. Keys and values can be either in numeric format, such as
   * `tagKeys/{tag_key_id}` and `tagValues/456` or in namespaced format such as
   * `{org_id|project_id}/{tag_key_short_name}` and `{tag_value_short_name}`. The field is ignored
   * (both PUT & PATCH) when empty.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getResourceManagerTags() {
    return resourceManagerTags;
  }

  /**
   * Resource manager tags to be bound to the snapshot. Tag keys and values have the same definition
   * as resource manager tags. Keys and values can be either in numeric format, such as
   * `tagKeys/{tag_key_id}` and `tagValues/456` or in namespaced format such as
   * `{org_id|project_id}/{tag_key_short_name}` and `{tag_value_short_name}`. The field is ignored
   * (both PUT & PATCH) when empty.
   * @param resourceManagerTags resourceManagerTags or {@code null} for none
   */
  public SnapshotParams setResourceManagerTags(java.util.Map<String, java.lang.String> resourceManagerTags) {
    this.resourceManagerTags = resourceManagerTags;
    return this;
  }

  @Override
  public SnapshotParams set(String fieldName, Object value) {
    return (SnapshotParams) super.set(fieldName, value);
  }

  @Override
  public SnapshotParams clone() {
    return (SnapshotParams) super.clone();
  }

}
