/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for TCPHealthCheck.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TCPHealthCheck extends com.google.api.client.json.GenericJson {

  /**
   * The TCP port number to which the health check prober sends packets. The default value is 80.
   * Valid values are 1 through65535.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer port;

  /**
   * Not supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String portName;

  /**
   * Specifies how a port is selected for health checking. Can be one of the following values:
   * USE_FIXED_PORT: Specifies a port number explicitly using theport field  in the health check.
   * Supported by backend services for passthrough load balancers and backend services for proxy
   * load balancers. Not supported by target pools. The health check supports all backends supported
   * by the backend service provided the backend can be health checked. For example, GCE_VM_IP
   * network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends.
   * USE_NAMED_PORT: Not supported.  USE_SERVING_PORT: Provides an indirect method of specifying the
   * health check port by referring to the backend service. Only supported by backend services for
   * proxy load balancers. Not supported by target pools.  Not supported by backend services for
   * passthrough load balancers. Supports all backends that can be health checked; for
   * example,GCE_VM_IP_PORT network endpoint groups and instance group backends.
   *
   * For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number
   * specified for each endpoint in the network endpoint group.  For instance group backends, the
   * health check uses the port number determined by looking up the backend service's named port in
   * the instance group's list of named ports.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String portSpecification;

  /**
   * Specifies the type of proxy header to append before sending data to the backend, either NONE or
   * PROXY_V1. The default is NONE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String proxyHeader;

  /**
   * Instructs the health check prober to send this exact ASCII string, up to 1024 bytes in length,
   * after establishing the TCP connection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String request;

  /**
   * Creates a content-based TCP health check. In addition to establishing a TCP connection, you can
   * configure the health check to pass only when the backend sends this exact response ASCII
   * string, up to 1024 bytes in length. For details, see: https://cloud.google.com/load-
   * balancing/docs/health-check-concepts#criteria-protocol-ssl-tcp
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String response;

  /**
   * The TCP port number to which the health check prober sends packets. The default value is 80.
   * Valid values are 1 through65535.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPort() {
    return port;
  }

  /**
   * The TCP port number to which the health check prober sends packets. The default value is 80.
   * Valid values are 1 through65535.
   * @param port port or {@code null} for none
   */
  public TCPHealthCheck setPort(java.lang.Integer port) {
    this.port = port;
    return this;
  }

  /**
   * Not supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getPortName() {
    return portName;
  }

  /**
   * Not supported.
   * @param portName portName or {@code null} for none
   */
  public TCPHealthCheck setPortName(java.lang.String portName) {
    this.portName = portName;
    return this;
  }

  /**
   * Specifies how a port is selected for health checking. Can be one of the following values:
   * USE_FIXED_PORT: Specifies a port number explicitly using theport field  in the health check.
   * Supported by backend services for passthrough load balancers and backend services for proxy
   * load balancers. Not supported by target pools. The health check supports all backends supported
   * by the backend service provided the backend can be health checked. For example, GCE_VM_IP
   * network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends.
   * USE_NAMED_PORT: Not supported.  USE_SERVING_PORT: Provides an indirect method of specifying the
   * health check port by referring to the backend service. Only supported by backend services for
   * proxy load balancers. Not supported by target pools.  Not supported by backend services for
   * passthrough load balancers. Supports all backends that can be health checked; for
   * example,GCE_VM_IP_PORT network endpoint groups and instance group backends.
   *
   * For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number
   * specified for each endpoint in the network endpoint group.  For instance group backends, the
   * health check uses the port number determined by looking up the backend service's named port in
   * the instance group's list of named ports.
   * @return value or {@code null} for none
   */
  public java.lang.String getPortSpecification() {
    return portSpecification;
  }

  /**
   * Specifies how a port is selected for health checking. Can be one of the following values:
   * USE_FIXED_PORT: Specifies a port number explicitly using theport field  in the health check.
   * Supported by backend services for passthrough load balancers and backend services for proxy
   * load balancers. Not supported by target pools. The health check supports all backends supported
   * by the backend service provided the backend can be health checked. For example, GCE_VM_IP
   * network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends.
   * USE_NAMED_PORT: Not supported.  USE_SERVING_PORT: Provides an indirect method of specifying the
   * health check port by referring to the backend service. Only supported by backend services for
   * proxy load balancers. Not supported by target pools.  Not supported by backend services for
   * passthrough load balancers. Supports all backends that can be health checked; for
   * example,GCE_VM_IP_PORT network endpoint groups and instance group backends.
   *
   * For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number
   * specified for each endpoint in the network endpoint group.  For instance group backends, the
   * health check uses the port number determined by looking up the backend service's named port in
   * the instance group's list of named ports.
   * @param portSpecification portSpecification or {@code null} for none
   */
  public TCPHealthCheck setPortSpecification(java.lang.String portSpecification) {
    this.portSpecification = portSpecification;
    return this;
  }

  /**
   * Specifies the type of proxy header to append before sending data to the backend, either NONE or
   * PROXY_V1. The default is NONE.
   * @return value or {@code null} for none
   */
  public java.lang.String getProxyHeader() {
    return proxyHeader;
  }

  /**
   * Specifies the type of proxy header to append before sending data to the backend, either NONE or
   * PROXY_V1. The default is NONE.
   * @param proxyHeader proxyHeader or {@code null} for none
   */
  public TCPHealthCheck setProxyHeader(java.lang.String proxyHeader) {
    this.proxyHeader = proxyHeader;
    return this;
  }

  /**
   * Instructs the health check prober to send this exact ASCII string, up to 1024 bytes in length,
   * after establishing the TCP connection.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequest() {
    return request;
  }

  /**
   * Instructs the health check prober to send this exact ASCII string, up to 1024 bytes in length,
   * after establishing the TCP connection.
   * @param request request or {@code null} for none
   */
  public TCPHealthCheck setRequest(java.lang.String request) {
    this.request = request;
    return this;
  }

  /**
   * Creates a content-based TCP health check. In addition to establishing a TCP connection, you can
   * configure the health check to pass only when the backend sends this exact response ASCII
   * string, up to 1024 bytes in length. For details, see: https://cloud.google.com/load-
   * balancing/docs/health-check-concepts#criteria-protocol-ssl-tcp
   * @return value or {@code null} for none
   */
  public java.lang.String getResponse() {
    return response;
  }

  /**
   * Creates a content-based TCP health check. In addition to establishing a TCP connection, you can
   * configure the health check to pass only when the backend sends this exact response ASCII
   * string, up to 1024 bytes in length. For details, see: https://cloud.google.com/load-
   * balancing/docs/health-check-concepts#criteria-protocol-ssl-tcp
   * @param response response or {@code null} for none
   */
  public TCPHealthCheck setResponse(java.lang.String response) {
    this.response = response;
    return this;
  }

  @Override
  public TCPHealthCheck set(String fieldName, Object value) {
    return (TCPHealthCheck) super.set(fieldName, value);
  }

  @Override
  public TCPHealthCheck clone() {
    return (TCPHealthCheck) super.clone();
  }

}
