/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The configuration for a custom policy implemented by the user and deployed with the client.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy extends com.google.api.client.json.GenericJson {

  /**
   * An optional, arbitrary JSON object with configuration data, understood by a locally installed
   * custom policy implementation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String data;

  /**
   * Identifies the custom policy.
   *
   * The value should match the name of a custom implementation registered on the gRPC clients. It
   * should follow protocol buffer message naming conventions and include the full path (for
   * example, myorg.CustomLbPolicy). The maximum length is 256 characters.
   *
   * Do not specify the same custom policy more than once for a backend. If you do, the
   * configuration is rejected.
   *
   * For an example of how to use this field, seeUse a custom policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * An optional, arbitrary JSON object with configuration data, understood by a locally installed
   * custom policy implementation.
   * @return value or {@code null} for none
   */
  public java.lang.String getData() {
    return data;
  }

  /**
   * An optional, arbitrary JSON object with configuration data, understood by a locally installed
   * custom policy implementation.
   * @param data data or {@code null} for none
   */
  public BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy setData(java.lang.String data) {
    this.data = data;
    return this;
  }

  /**
   * Identifies the custom policy.
   *
   * The value should match the name of a custom implementation registered on the gRPC clients. It
   * should follow protocol buffer message naming conventions and include the full path (for
   * example, myorg.CustomLbPolicy). The maximum length is 256 characters.
   *
   * Do not specify the same custom policy more than once for a backend. If you do, the
   * configuration is rejected.
   *
   * For an example of how to use this field, seeUse a custom policy.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Identifies the custom policy.
   *
   * The value should match the name of a custom implementation registered on the gRPC clients. It
   * should follow protocol buffer message naming conventions and include the full path (for
   * example, myorg.CustomLbPolicy). The maximum length is 256 characters.
   *
   * Do not specify the same custom policy more than once for a backend. If you do, the
   * configuration is rejected.
   *
   * For an example of how to use this field, seeUse a custom policy.
   * @param name name or {@code null} for none
   */
  public BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy set(String fieldName, Object value) {
    return (BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy) super.set(fieldName, value);
  }

  @Override
  public BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy clone() {
    return (BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy) super.clone();
  }

}
