/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The interface for the external VPN gateway.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ExternalVpnGatewayInterface extends com.google.api.client.json.GenericJson {

  /**
   * The numeric ID of this interface. The allowed input values for this id for different redundancy
   * types of external VPN gateway:        - SINGLE_IP_INTERNALLY_REDUNDANT - 0    -
   * TWO_IPS_REDUNDANCY - 0, 1    - FOUR_IPS_REDUNDANCY - 0, 1, 2, 3
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long id;

  /**
   * IP address of the interface in the external VPN gateway. Only IPv4 is supported. This IP
   * address can be either from your on-premise gateway or another Cloud provider's VPN gateway, it
   * cannot be an IP address from Google Compute Engine.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipAddress;

  /**
   * IPv6 address of the interface in the external VPN gateway. This IPv6 address can be either from
   * your on-premise gateway or another Cloud provider's VPN gateway, it cannot be an IP address
   * from Google Compute Engine. Must specify an IPv6 address (not IPV4-mapped) using any format
   * described in RFC 4291 (e.g. 2001:db8:0:0:2d9:51:0:0). The output format is RFC 5952 format
   * (e.g. 2001:db8::2d9:51:0:0).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipv6Address;

  /**
   * The numeric ID of this interface. The allowed input values for this id for different redundancy
   * types of external VPN gateway:        - SINGLE_IP_INTERNALLY_REDUNDANT - 0    -
   * TWO_IPS_REDUNDANCY - 0, 1    - FOUR_IPS_REDUNDANCY - 0, 1, 2, 3
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * The numeric ID of this interface. The allowed input values for this id for different redundancy
   * types of external VPN gateway:        - SINGLE_IP_INTERNALLY_REDUNDANT - 0    -
   * TWO_IPS_REDUNDANCY - 0, 1    - FOUR_IPS_REDUNDANCY - 0, 1, 2, 3
   * @param id id or {@code null} for none
   */
  public ExternalVpnGatewayInterface setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * IP address of the interface in the external VPN gateway. Only IPv4 is supported. This IP
   * address can be either from your on-premise gateway or another Cloud provider's VPN gateway, it
   * cannot be an IP address from Google Compute Engine.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpAddress() {
    return ipAddress;
  }

  /**
   * IP address of the interface in the external VPN gateway. Only IPv4 is supported. This IP
   * address can be either from your on-premise gateway or another Cloud provider's VPN gateway, it
   * cannot be an IP address from Google Compute Engine.
   * @param ipAddress ipAddress or {@code null} for none
   */
  public ExternalVpnGatewayInterface setIpAddress(java.lang.String ipAddress) {
    this.ipAddress = ipAddress;
    return this;
  }

  /**
   * IPv6 address of the interface in the external VPN gateway. This IPv6 address can be either from
   * your on-premise gateway or another Cloud provider's VPN gateway, it cannot be an IP address
   * from Google Compute Engine. Must specify an IPv6 address (not IPV4-mapped) using any format
   * described in RFC 4291 (e.g. 2001:db8:0:0:2d9:51:0:0). The output format is RFC 5952 format
   * (e.g. 2001:db8::2d9:51:0:0).
   * @return value or {@code null} for none
   */
  public java.lang.String getIpv6Address() {
    return ipv6Address;
  }

  /**
   * IPv6 address of the interface in the external VPN gateway. This IPv6 address can be either from
   * your on-premise gateway or another Cloud provider's VPN gateway, it cannot be an IP address
   * from Google Compute Engine. Must specify an IPv6 address (not IPV4-mapped) using any format
   * described in RFC 4291 (e.g. 2001:db8:0:0:2d9:51:0:0). The output format is RFC 5952 format
   * (e.g. 2001:db8::2d9:51:0:0).
   * @param ipv6Address ipv6Address or {@code null} for none
   */
  public ExternalVpnGatewayInterface setIpv6Address(java.lang.String ipv6Address) {
    this.ipv6Address = ipv6Address;
    return this;
  }

  @Override
  public ExternalVpnGatewayInterface set(String fieldName, Object value) {
    return (ExternalVpnGatewayInterface) super.set(fieldName, value);
  }

  @Override
  public ExternalVpnGatewayInterface clone() {
    return (ExternalVpnGatewayInterface) super.clone();
  }

}
