/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Specifies the delay introduced by the load balancer before forwarding the request to the backend
 * service as part of fault injection.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HttpFaultDelay extends com.google.api.client.json.GenericJson {

  /**
   * Specifies the value of the fixed delay interval.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Duration fixedDelay;

  /**
   * The percentage of traffic for connections, operations, or requests for which a delay is
   * introduced as part of fault injection.
   *
   * The value must be from 0.0 to 100.0 inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double percentage;

  /**
   * Specifies the value of the fixed delay interval.
   * @return value or {@code null} for none
   */
  public Duration getFixedDelay() {
    return fixedDelay;
  }

  /**
   * Specifies the value of the fixed delay interval.
   * @param fixedDelay fixedDelay or {@code null} for none
   */
  public HttpFaultDelay setFixedDelay(Duration fixedDelay) {
    this.fixedDelay = fixedDelay;
    return this;
  }

  /**
   * The percentage of traffic for connections, operations, or requests for which a delay is
   * introduced as part of fault injection.
   *
   * The value must be from 0.0 to 100.0 inclusive.
   * @return value or {@code null} for none
   */
  public java.lang.Double getPercentage() {
    return percentage;
  }

  /**
   * The percentage of traffic for connections, operations, or requests for which a delay is
   * introduced as part of fault injection.
   *
   * The value must be from 0.0 to 100.0 inclusive.
   * @param percentage percentage or {@code null} for none
   */
  public HttpFaultDelay setPercentage(java.lang.Double percentage) {
    this.percentage = percentage;
    return this;
  }

  @Override
  public HttpFaultDelay set(String fieldName, Object value) {
    return (HttpFaultDelay) super.set(fieldName, value);
  }

  @Override
  public HttpFaultDelay clone() {
    return (HttpFaultDelay) super.clone();
  }

}
