/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerResourcePolicies.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerResourcePolicies extends com.google.api.client.json.GenericJson {

  /**
   * The URL of the workload policy that is specified for this managed instance group. It can be a
   * full or partial URL. For example, the following are all valid URLs to a workload policy:
   * - https://www.googleapis.com/compute/v1/projects/project/regions/region/resourcePolicies/resour
   * cePolicy       - projects/project/regions/region/resourcePolicies/resourcePolicy       -
   * regions/region/resourcePolicies/resourcePolicy
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String workloadPolicy;

  /**
   * The URL of the workload policy that is specified for this managed instance group. It can be a
   * full or partial URL. For example, the following are all valid URLs to a workload policy:
   * - https://www.googleapis.com/compute/v1/projects/project/regions/region/resourcePolicies/resour
   * cePolicy       - projects/project/regions/region/resourcePolicies/resourcePolicy       -
   * regions/region/resourcePolicies/resourcePolicy
   * @return value or {@code null} for none
   */
  public java.lang.String getWorkloadPolicy() {
    return workloadPolicy;
  }

  /**
   * The URL of the workload policy that is specified for this managed instance group. It can be a
   * full or partial URL. For example, the following are all valid URLs to a workload policy:
   * - https://www.googleapis.com/compute/v1/projects/project/regions/region/resourcePolicies/resour
   * cePolicy       - projects/project/regions/region/resourcePolicies/resourcePolicy       -
   * regions/region/resourcePolicies/resourcePolicy
   * @param workloadPolicy workloadPolicy or {@code null} for none
   */
  public InstanceGroupManagerResourcePolicies setWorkloadPolicy(java.lang.String workloadPolicy) {
    this.workloadPolicy = workloadPolicy;
    return this;
  }

  @Override
  public InstanceGroupManagerResourcePolicies set(String fieldName, Object value) {
    return (InstanceGroupManagerResourcePolicies) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerResourcePolicies clone() {
    return (InstanceGroupManagerResourcePolicies) super.clone();
  }

}
