/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InterconnectAttachmentConfigurationConstraints.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectAttachmentConfigurationConstraints extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Whether the attachment's BGP session requires/allows/disallows BGP MD5
   * authentication. This can take one of the following values: MD5_OPTIONAL, MD5_REQUIRED,
   * MD5_UNSUPPORTED.
   *
   * For example, a Cross-Cloud Interconnect connection to a remote cloud provider that requires BGP
   * MD5 authentication has the interconnectRemoteLocation
   * attachment_configuration_constraints.bgp_md5 field set to MD5_REQUIRED, and that property is
   * propagated to the attachment. Similarly, if BGP MD5 is MD5_UNSUPPORTED, an error is returned if
   * MD5 is requested.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bgpMd5;

  /**
   * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an
   * array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123},
   * {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534.
   *
   * This field is only advisory. Although the API accepts other ranges, these are the ranges that
   * we recommend.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange> bgpPeerAsnRanges;

  /**
   * [Output Only] Whether the attachment's BGP session requires/allows/disallows BGP MD5
   * authentication. This can take one of the following values: MD5_OPTIONAL, MD5_REQUIRED,
   * MD5_UNSUPPORTED.
   *
   * For example, a Cross-Cloud Interconnect connection to a remote cloud provider that requires BGP
   * MD5 authentication has the interconnectRemoteLocation
   * attachment_configuration_constraints.bgp_md5 field set to MD5_REQUIRED, and that property is
   * propagated to the attachment. Similarly, if BGP MD5 is MD5_UNSUPPORTED, an error is returned if
   * MD5 is requested.
   * @return value or {@code null} for none
   */
  public java.lang.String getBgpMd5() {
    return bgpMd5;
  }

  /**
   * [Output Only] Whether the attachment's BGP session requires/allows/disallows BGP MD5
   * authentication. This can take one of the following values: MD5_OPTIONAL, MD5_REQUIRED,
   * MD5_UNSUPPORTED.
   *
   * For example, a Cross-Cloud Interconnect connection to a remote cloud provider that requires BGP
   * MD5 authentication has the interconnectRemoteLocation
   * attachment_configuration_constraints.bgp_md5 field set to MD5_REQUIRED, and that property is
   * propagated to the attachment. Similarly, if BGP MD5 is MD5_UNSUPPORTED, an error is returned if
   * MD5 is requested.
   * @param bgpMd5 bgpMd5 or {@code null} for none
   */
  public InterconnectAttachmentConfigurationConstraints setBgpMd5(java.lang.String bgpMd5) {
    this.bgpMd5 = bgpMd5;
    return this;
  }

  /**
   * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an
   * array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123},
   * {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534.
   *
   * This field is only advisory. Although the API accepts other ranges, these are the ranges that
   * we recommend.
   * @return value or {@code null} for none
   */
  public java.util.List<InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange> getBgpPeerAsnRanges() {
    return bgpPeerAsnRanges;
  }

  /**
   * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an
   * array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123},
   * {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534.
   *
   * This field is only advisory. Although the API accepts other ranges, these are the ranges that
   * we recommend.
   * @param bgpPeerAsnRanges bgpPeerAsnRanges or {@code null} for none
   */
  public InterconnectAttachmentConfigurationConstraints setBgpPeerAsnRanges(java.util.List<InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange> bgpPeerAsnRanges) {
    this.bgpPeerAsnRanges = bgpPeerAsnRanges;
    return this;
  }

  @Override
  public InterconnectAttachmentConfigurationConstraints set(String fieldName, Object value) {
    return (InterconnectAttachmentConfigurationConstraints) super.set(fieldName, value);
  }

  @Override
  public InterconnectAttachmentConfigurationConstraints clone() {
    return (InterconnectAttachmentConfigurationConstraints) super.clone();
  }

}
