/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * NetworkAttachments A network attachment resource ...
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkAttachment extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] An array of connections for all the producers connected to this network
   * attachment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<NetworkAttachmentConnectedEndpoint> connectionEndpoints;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String connectionPreference;

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. An up-to-date fingerprint must be provided in order to patch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fingerprint;

  /**
   * [Output Only] The unique identifier for the resource type. The server generates this
   * identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply withRFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] The URL of the network which the Network Attachment belongs to. Practically it is
   * inferred by fetching the network of the first subnetwork associated. Because it is required
   * that all the subnetworks must be from the same network, it is assured that the Network
   * Attachment belongs to the same network as all the subnetworks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String network;

  /**
   * Projects that are allowed to connect to this network attachment. The project can be specified
   * using its id or number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> producerAcceptLists;

  /**
   * Projects that are not allowed to connect to this network attachment. The project can be
   * specified using its id or number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> producerRejectLists;

  /**
   * [Output Only] URL of the region where the network attachment resides. This field applies only
   * to the region resource. You must specify this field as part of the HTTP request URL. It is not
   * settable as a field in the request body.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] Server-defined URL for this resource's resource id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLinkWithId;

  /**
   * An array of URLs where each entry is the URL of a subnet provided by the service consumer to
   * use for endpoints in the producers that connect to this network attachment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> subnetworks;

  /**
   * [Output Only] An array of connections for all the producers connected to this network
   * attachment.
   * @return value or {@code null} for none
   */
  public java.util.List<NetworkAttachmentConnectedEndpoint> getConnectionEndpoints() {
    return connectionEndpoints;
  }

  /**
   * [Output Only] An array of connections for all the producers connected to this network
   * attachment.
   * @param connectionEndpoints connectionEndpoints or {@code null} for none
   */
  public NetworkAttachment setConnectionEndpoints(java.util.List<NetworkAttachmentConnectedEndpoint> connectionEndpoints) {
    this.connectionEndpoints = connectionEndpoints;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getConnectionPreference() {
    return connectionPreference;
  }

  /**
   * @param connectionPreference connectionPreference or {@code null} for none
   */
  public NetworkAttachment setConnectionPreference(java.lang.String connectionPreference) {
    this.connectionPreference = connectionPreference;
    return this;
  }

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public NetworkAttachment setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public NetworkAttachment setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. An up-to-date fingerprint must be provided in order to patch.
   * @see #decodeFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getFingerprint() {
    return fingerprint;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. An up-to-date fingerprint must be provided in order to patch.
   * @see #getFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(fingerprint);
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. An up-to-date fingerprint must be provided in order to patch.
   * @see #encodeFingerprint()
   * @param fingerprint fingerprint or {@code null} for none
   */
  public NetworkAttachment setFingerprint(java.lang.String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. An up-to-date fingerprint must be provided in order to patch.
   * @see #setFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public NetworkAttachment encodeFingerprint(byte[] fingerprint) {
    this.fingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(fingerprint);
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource type. The server generates this
   * identifier.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource type. The server generates this
   * identifier.
   * @param id id or {@code null} for none
   */
  public NetworkAttachment setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] Type of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource.
   * @param kind kind or {@code null} for none
   */
  public NetworkAttachment setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply withRFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply withRFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public NetworkAttachment setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] The URL of the network which the Network Attachment belongs to. Practically it is
   * inferred by fetching the network of the first subnetwork associated. Because it is required
   * that all the subnetworks must be from the same network, it is assured that the Network
   * Attachment belongs to the same network as all the subnetworks.
   * @return value or {@code null} for none
   */
  public java.lang.String getNetwork() {
    return network;
  }

  /**
   * [Output Only] The URL of the network which the Network Attachment belongs to. Practically it is
   * inferred by fetching the network of the first subnetwork associated. Because it is required
   * that all the subnetworks must be from the same network, it is assured that the Network
   * Attachment belongs to the same network as all the subnetworks.
   * @param network network or {@code null} for none
   */
  public NetworkAttachment setNetwork(java.lang.String network) {
    this.network = network;
    return this;
  }

  /**
   * Projects that are allowed to connect to this network attachment. The project can be specified
   * using its id or number.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getProducerAcceptLists() {
    return producerAcceptLists;
  }

  /**
   * Projects that are allowed to connect to this network attachment. The project can be specified
   * using its id or number.
   * @param producerAcceptLists producerAcceptLists or {@code null} for none
   */
  public NetworkAttachment setProducerAcceptLists(java.util.List<java.lang.String> producerAcceptLists) {
    this.producerAcceptLists = producerAcceptLists;
    return this;
  }

  /**
   * Projects that are not allowed to connect to this network attachment. The project can be
   * specified using its id or number.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getProducerRejectLists() {
    return producerRejectLists;
  }

  /**
   * Projects that are not allowed to connect to this network attachment. The project can be
   * specified using its id or number.
   * @param producerRejectLists producerRejectLists or {@code null} for none
   */
  public NetworkAttachment setProducerRejectLists(java.util.List<java.lang.String> producerRejectLists) {
    this.producerRejectLists = producerRejectLists;
    return this;
  }

  /**
   * [Output Only] URL of the region where the network attachment resides. This field applies only
   * to the region resource. You must specify this field as part of the HTTP request URL. It is not
   * settable as a field in the request body.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * [Output Only] URL of the region where the network attachment resides. This field applies only
   * to the region resource. You must specify this field as part of the HTTP request URL. It is not
   * settable as a field in the request body.
   * @param region region or {@code null} for none
   */
  public NetworkAttachment setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public NetworkAttachment setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for this resource's resource id.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLinkWithId() {
    return selfLinkWithId;
  }

  /**
   * [Output Only] Server-defined URL for this resource's resource id.
   * @param selfLinkWithId selfLinkWithId or {@code null} for none
   */
  public NetworkAttachment setSelfLinkWithId(java.lang.String selfLinkWithId) {
    this.selfLinkWithId = selfLinkWithId;
    return this;
  }

  /**
   * An array of URLs where each entry is the URL of a subnet provided by the service consumer to
   * use for endpoints in the producers that connect to this network attachment.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSubnetworks() {
    return subnetworks;
  }

  /**
   * An array of URLs where each entry is the URL of a subnet provided by the service consumer to
   * use for endpoints in the producers that connect to this network attachment.
   * @param subnetworks subnetworks or {@code null} for none
   */
  public NetworkAttachment setSubnetworks(java.util.List<java.lang.String> subnetworks) {
    this.subnetworks = subnetworks;
    return this;
  }

  @Override
  public NetworkAttachment set(String fieldName, Object value) {
    return (NetworkAttachment) super.set(fieldName, value);
  }

  @Override
  public NetworkAttachment clone() {
    return (NetworkAttachment) super.clone();
  }

}
