/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * [Output Only] Describes the state of a peering connection, not just the local peering. This field
 * provides information about the effective settings for the connection as a whole, including
 * pending delete/update requests for CONSENSUS peerings.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkPeeringConnectionStatus extends com.google.api.client.json.GenericJson {

  /**
   * The consensus state contains information about the status of update and delete for a consensus
   * peering connection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NetworkPeeringConnectionStatusConsensusState consensusState;

  /**
   * The active connectivity settings for the peering connection based on the settings of the
   * network peerings.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NetworkPeeringConnectionStatusTrafficConfiguration trafficConfiguration;

  /**
   * The update strategy determines the update/delete semantics for this peering connection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String updateStrategy;

  /**
   * The consensus state contains information about the status of update and delete for a consensus
   * peering connection.
   * @return value or {@code null} for none
   */
  public NetworkPeeringConnectionStatusConsensusState getConsensusState() {
    return consensusState;
  }

  /**
   * The consensus state contains information about the status of update and delete for a consensus
   * peering connection.
   * @param consensusState consensusState or {@code null} for none
   */
  public NetworkPeeringConnectionStatus setConsensusState(NetworkPeeringConnectionStatusConsensusState consensusState) {
    this.consensusState = consensusState;
    return this;
  }

  /**
   * The active connectivity settings for the peering connection based on the settings of the
   * network peerings.
   * @return value or {@code null} for none
   */
  public NetworkPeeringConnectionStatusTrafficConfiguration getTrafficConfiguration() {
    return trafficConfiguration;
  }

  /**
   * The active connectivity settings for the peering connection based on the settings of the
   * network peerings.
   * @param trafficConfiguration trafficConfiguration or {@code null} for none
   */
  public NetworkPeeringConnectionStatus setTrafficConfiguration(NetworkPeeringConnectionStatusTrafficConfiguration trafficConfiguration) {
    this.trafficConfiguration = trafficConfiguration;
    return this;
  }

  /**
   * The update strategy determines the update/delete semantics for this peering connection.
   * @return value or {@code null} for none
   */
  public java.lang.String getUpdateStrategy() {
    return updateStrategy;
  }

  /**
   * The update strategy determines the update/delete semantics for this peering connection.
   * @param updateStrategy updateStrategy or {@code null} for none
   */
  public NetworkPeeringConnectionStatus setUpdateStrategy(java.lang.String updateStrategy) {
    this.updateStrategy = updateStrategy;
    return this;
  }

  @Override
  public NetworkPeeringConnectionStatus set(String fieldName, Object value) {
    return (NetworkPeeringConnectionStatus) super.set(fieldName, value);
  }

  @Override
  public NetworkPeeringConnectionStatus clone() {
    return (NetworkPeeringConnectionStatus) super.clone();
  }

}
