/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * NetworkProfile represents a Google managed network profile resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkProfile extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * [Output Only] An optional description of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] Features supported by the network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NetworkProfileNetworkFeatures features;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] Type of the resource. Alwayscompute#networkProfile for network profiles.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Output Only] Location to which the network is restricted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NetworkProfileLocation location;

  /**
   * [Output Only] Name of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] Type of the network profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NetworkProfileProfileType profileType;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLinkWithId;

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public NetworkProfile setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * [Output Only] An optional description of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * [Output Only] An optional description of this resource.
   * @param description description or {@code null} for none
   */
  public NetworkProfile setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] Features supported by the network.
   * @return value or {@code null} for none
   */
  public NetworkProfileNetworkFeatures getFeatures() {
    return features;
  }

  /**
   * [Output Only] Features supported by the network.
   * @param features features or {@code null} for none
   */
  public NetworkProfile setFeatures(NetworkProfileNetworkFeatures features) {
    this.features = features;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public NetworkProfile setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Alwayscompute#networkProfile for network profiles.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Alwayscompute#networkProfile for network profiles.
   * @param kind kind or {@code null} for none
   */
  public NetworkProfile setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Output Only] Location to which the network is restricted.
   * @return value or {@code null} for none
   */
  public NetworkProfileLocation getLocation() {
    return location;
  }

  /**
   * [Output Only] Location to which the network is restricted.
   * @param location location or {@code null} for none
   */
  public NetworkProfile setLocation(NetworkProfileLocation location) {
    this.location = location;
    return this;
  }

  /**
   * [Output Only] Name of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * [Output Only] Name of the resource.
   * @param name name or {@code null} for none
   */
  public NetworkProfile setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] Type of the network profile.
   * @return value or {@code null} for none
   */
  public NetworkProfileProfileType getProfileType() {
    return profileType;
  }

  /**
   * [Output Only] Type of the network profile.
   * @param profileType profileType or {@code null} for none
   */
  public NetworkProfile setProfileType(NetworkProfileProfileType profileType) {
    this.profileType = profileType;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public NetworkProfile setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLinkWithId() {
    return selfLinkWithId;
  }

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * @param selfLinkWithId selfLinkWithId or {@code null} for none
   */
  public NetworkProfile setSelfLinkWithId(java.lang.String selfLinkWithId) {
    this.selfLinkWithId = selfLinkWithId;
    return this;
  }

  @Override
  public NetworkProfile set(String fieldName, Object value) {
    return (NetworkProfile) super.set(fieldName, value);
  }

  @Override
  public NetworkProfile clone() {
    return (NetworkProfile) super.clone();
  }

}
