/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for NetworkProfileNetworkFeatures.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkProfileNetworkFeatures extends com.google.api.client.json.GenericJson {

  /**
   * Specifies what address purposes are supported. If empty, all address purposes are supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> addressPurposes;

  /**
   * Specifies whether alias IP ranges (and secondary address ranges) are allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowAliasIpRanges;

  /**
   * Specifies whether auto mode subnet creation is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowAutoModeSubnet;

  /**
   * Specifies whether firewalls for Class D address ranges are supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowClassDFirewalls;

  /**
   * Specifies whether cloud NAT creation is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowCloudNat;

  /**
   * Specifies whether cloud router creation is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowCloudRouter;

  /**
   * Specifies whether default NIC attachment is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowDefaultNicAttachment;

  /**
   * Specifies whether VMs are allowed to have external IP access on network interfaces connected to
   * this VPC.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowExternalIpAccess;

  /**
   * Specifies whether Cloud Interconnect creation is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowInterconnect;

  /**
   * Specifies whether IP forwarding is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowIpForwarding;

  /**
   * Specifies whether cloud load balancing is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowLoadBalancing;

  /**
   * Specifies whether multi-nic in the same network is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowMultiNicInSameNetwork;

  /**
   * Specifies whether multicast is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowMulticast;

  /**
   * Specifies whether NCC is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowNcc;

  /**
   * Specifies whether VM network migration is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowNetworkMigration;

  /**
   * Specifies whether Packet Mirroring 1.0 is supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowPacketMirroring;

  /**
   * Specifies whether private Google access is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowPrivateGoogleAccess;

  /**
   * Specifies whether PSC creation is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowPsc;

  /**
   * Specifies whether unicast within the same network is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowSameNetworkUnicast;

  /**
   * Specifies whether static route creation is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowStaticRoutes;

  /**
   * Specifies whether sub interfaces are allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowSubInterfaces;

  /**
   * Specifies whether VPC peering is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowVpcPeering;

  /**
   * Specifies whether VPN creation is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowVpn;

  /**
   * If set, limits the interface types that the network supports. If empty, all interface types are
   * supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> interfaceTypes;

  /**
   * Specifies which type of multicast is supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String multicast;

  /**
   * Specifies which subnetwork purposes are supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> subnetPurposes;

  /**
   * Specifies which subnetwork stack types are supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> subnetStackTypes;

  /**
   * Specifies which subnetwork purposes are supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> subnetworkPurposes;

  /**
   * Specifies which subnetwork stack types are supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> subnetworkStackTypes;

  /**
   * Specifies which type of unicast is supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String unicast;

  /**
   * Specifies what address purposes are supported. If empty, all address purposes are supported.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAddressPurposes() {
    return addressPurposes;
  }

  /**
   * Specifies what address purposes are supported. If empty, all address purposes are supported.
   * @param addressPurposes addressPurposes or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAddressPurposes(java.util.List<java.lang.String> addressPurposes) {
    this.addressPurposes = addressPurposes;
    return this;
  }

  /**
   * Specifies whether alias IP ranges (and secondary address ranges) are allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowAliasIpRanges() {
    return allowAliasIpRanges;
  }

  /**
   * Specifies whether alias IP ranges (and secondary address ranges) are allowed.
   * @param allowAliasIpRanges allowAliasIpRanges or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowAliasIpRanges(java.lang.String allowAliasIpRanges) {
    this.allowAliasIpRanges = allowAliasIpRanges;
    return this;
  }

  /**
   * Specifies whether auto mode subnet creation is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowAutoModeSubnet() {
    return allowAutoModeSubnet;
  }

  /**
   * Specifies whether auto mode subnet creation is allowed.
   * @param allowAutoModeSubnet allowAutoModeSubnet or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowAutoModeSubnet(java.lang.String allowAutoModeSubnet) {
    this.allowAutoModeSubnet = allowAutoModeSubnet;
    return this;
  }

  /**
   * Specifies whether firewalls for Class D address ranges are supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowClassDFirewalls() {
    return allowClassDFirewalls;
  }

  /**
   * Specifies whether firewalls for Class D address ranges are supported.
   * @param allowClassDFirewalls allowClassDFirewalls or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowClassDFirewalls(java.lang.String allowClassDFirewalls) {
    this.allowClassDFirewalls = allowClassDFirewalls;
    return this;
  }

  /**
   * Specifies whether cloud NAT creation is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowCloudNat() {
    return allowCloudNat;
  }

  /**
   * Specifies whether cloud NAT creation is allowed.
   * @param allowCloudNat allowCloudNat or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowCloudNat(java.lang.String allowCloudNat) {
    this.allowCloudNat = allowCloudNat;
    return this;
  }

  /**
   * Specifies whether cloud router creation is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowCloudRouter() {
    return allowCloudRouter;
  }

  /**
   * Specifies whether cloud router creation is allowed.
   * @param allowCloudRouter allowCloudRouter or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowCloudRouter(java.lang.String allowCloudRouter) {
    this.allowCloudRouter = allowCloudRouter;
    return this;
  }

  /**
   * Specifies whether default NIC attachment is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowDefaultNicAttachment() {
    return allowDefaultNicAttachment;
  }

  /**
   * Specifies whether default NIC attachment is allowed.
   * @param allowDefaultNicAttachment allowDefaultNicAttachment or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowDefaultNicAttachment(java.lang.String allowDefaultNicAttachment) {
    this.allowDefaultNicAttachment = allowDefaultNicAttachment;
    return this;
  }

  /**
   * Specifies whether VMs are allowed to have external IP access on network interfaces connected to
   * this VPC.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowExternalIpAccess() {
    return allowExternalIpAccess;
  }

  /**
   * Specifies whether VMs are allowed to have external IP access on network interfaces connected to
   * this VPC.
   * @param allowExternalIpAccess allowExternalIpAccess or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowExternalIpAccess(java.lang.String allowExternalIpAccess) {
    this.allowExternalIpAccess = allowExternalIpAccess;
    return this;
  }

  /**
   * Specifies whether Cloud Interconnect creation is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowInterconnect() {
    return allowInterconnect;
  }

  /**
   * Specifies whether Cloud Interconnect creation is allowed.
   * @param allowInterconnect allowInterconnect or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowInterconnect(java.lang.String allowInterconnect) {
    this.allowInterconnect = allowInterconnect;
    return this;
  }

  /**
   * Specifies whether IP forwarding is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowIpForwarding() {
    return allowIpForwarding;
  }

  /**
   * Specifies whether IP forwarding is allowed.
   * @param allowIpForwarding allowIpForwarding or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowIpForwarding(java.lang.String allowIpForwarding) {
    this.allowIpForwarding = allowIpForwarding;
    return this;
  }

  /**
   * Specifies whether cloud load balancing is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowLoadBalancing() {
    return allowLoadBalancing;
  }

  /**
   * Specifies whether cloud load balancing is allowed.
   * @param allowLoadBalancing allowLoadBalancing or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowLoadBalancing(java.lang.String allowLoadBalancing) {
    this.allowLoadBalancing = allowLoadBalancing;
    return this;
  }

  /**
   * Specifies whether multi-nic in the same network is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowMultiNicInSameNetwork() {
    return allowMultiNicInSameNetwork;
  }

  /**
   * Specifies whether multi-nic in the same network is allowed.
   * @param allowMultiNicInSameNetwork allowMultiNicInSameNetwork or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowMultiNicInSameNetwork(java.lang.String allowMultiNicInSameNetwork) {
    this.allowMultiNicInSameNetwork = allowMultiNicInSameNetwork;
    return this;
  }

  /**
   * Specifies whether multicast is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowMulticast() {
    return allowMulticast;
  }

  /**
   * Specifies whether multicast is allowed.
   * @param allowMulticast allowMulticast or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowMulticast(java.lang.String allowMulticast) {
    this.allowMulticast = allowMulticast;
    return this;
  }

  /**
   * Specifies whether NCC is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowNcc() {
    return allowNcc;
  }

  /**
   * Specifies whether NCC is allowed.
   * @param allowNcc allowNcc or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowNcc(java.lang.String allowNcc) {
    this.allowNcc = allowNcc;
    return this;
  }

  /**
   * Specifies whether VM network migration is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowNetworkMigration() {
    return allowNetworkMigration;
  }

  /**
   * Specifies whether VM network migration is allowed.
   * @param allowNetworkMigration allowNetworkMigration or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowNetworkMigration(java.lang.String allowNetworkMigration) {
    this.allowNetworkMigration = allowNetworkMigration;
    return this;
  }

  /**
   * Specifies whether Packet Mirroring 1.0 is supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowPacketMirroring() {
    return allowPacketMirroring;
  }

  /**
   * Specifies whether Packet Mirroring 1.0 is supported.
   * @param allowPacketMirroring allowPacketMirroring or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowPacketMirroring(java.lang.String allowPacketMirroring) {
    this.allowPacketMirroring = allowPacketMirroring;
    return this;
  }

  /**
   * Specifies whether private Google access is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowPrivateGoogleAccess() {
    return allowPrivateGoogleAccess;
  }

  /**
   * Specifies whether private Google access is allowed.
   * @param allowPrivateGoogleAccess allowPrivateGoogleAccess or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowPrivateGoogleAccess(java.lang.String allowPrivateGoogleAccess) {
    this.allowPrivateGoogleAccess = allowPrivateGoogleAccess;
    return this;
  }

  /**
   * Specifies whether PSC creation is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowPsc() {
    return allowPsc;
  }

  /**
   * Specifies whether PSC creation is allowed.
   * @param allowPsc allowPsc or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowPsc(java.lang.String allowPsc) {
    this.allowPsc = allowPsc;
    return this;
  }

  /**
   * Specifies whether unicast within the same network is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowSameNetworkUnicast() {
    return allowSameNetworkUnicast;
  }

  /**
   * Specifies whether unicast within the same network is allowed.
   * @param allowSameNetworkUnicast allowSameNetworkUnicast or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowSameNetworkUnicast(java.lang.String allowSameNetworkUnicast) {
    this.allowSameNetworkUnicast = allowSameNetworkUnicast;
    return this;
  }

  /**
   * Specifies whether static route creation is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowStaticRoutes() {
    return allowStaticRoutes;
  }

  /**
   * Specifies whether static route creation is allowed.
   * @param allowStaticRoutes allowStaticRoutes or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowStaticRoutes(java.lang.String allowStaticRoutes) {
    this.allowStaticRoutes = allowStaticRoutes;
    return this;
  }

  /**
   * Specifies whether sub interfaces are allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowSubInterfaces() {
    return allowSubInterfaces;
  }

  /**
   * Specifies whether sub interfaces are allowed.
   * @param allowSubInterfaces allowSubInterfaces or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowSubInterfaces(java.lang.String allowSubInterfaces) {
    this.allowSubInterfaces = allowSubInterfaces;
    return this;
  }

  /**
   * Specifies whether VPC peering is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowVpcPeering() {
    return allowVpcPeering;
  }

  /**
   * Specifies whether VPC peering is allowed.
   * @param allowVpcPeering allowVpcPeering or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowVpcPeering(java.lang.String allowVpcPeering) {
    this.allowVpcPeering = allowVpcPeering;
    return this;
  }

  /**
   * Specifies whether VPN creation is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowVpn() {
    return allowVpn;
  }

  /**
   * Specifies whether VPN creation is allowed.
   * @param allowVpn allowVpn or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setAllowVpn(java.lang.String allowVpn) {
    this.allowVpn = allowVpn;
    return this;
  }

  /**
   * If set, limits the interface types that the network supports. If empty, all interface types are
   * supported.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getInterfaceTypes() {
    return interfaceTypes;
  }

  /**
   * If set, limits the interface types that the network supports. If empty, all interface types are
   * supported.
   * @param interfaceTypes interfaceTypes or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setInterfaceTypes(java.util.List<java.lang.String> interfaceTypes) {
    this.interfaceTypes = interfaceTypes;
    return this;
  }

  /**
   * Specifies which type of multicast is supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getMulticast() {
    return multicast;
  }

  /**
   * Specifies which type of multicast is supported.
   * @param multicast multicast or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setMulticast(java.lang.String multicast) {
    this.multicast = multicast;
    return this;
  }

  /**
   * Specifies which subnetwork purposes are supported.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSubnetPurposes() {
    return subnetPurposes;
  }

  /**
   * Specifies which subnetwork purposes are supported.
   * @param subnetPurposes subnetPurposes or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setSubnetPurposes(java.util.List<java.lang.String> subnetPurposes) {
    this.subnetPurposes = subnetPurposes;
    return this;
  }

  /**
   * Specifies which subnetwork stack types are supported.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSubnetStackTypes() {
    return subnetStackTypes;
  }

  /**
   * Specifies which subnetwork stack types are supported.
   * @param subnetStackTypes subnetStackTypes or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setSubnetStackTypes(java.util.List<java.lang.String> subnetStackTypes) {
    this.subnetStackTypes = subnetStackTypes;
    return this;
  }

  /**
   * Specifies which subnetwork purposes are supported.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSubnetworkPurposes() {
    return subnetworkPurposes;
  }

  /**
   * Specifies which subnetwork purposes are supported.
   * @param subnetworkPurposes subnetworkPurposes or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setSubnetworkPurposes(java.util.List<java.lang.String> subnetworkPurposes) {
    this.subnetworkPurposes = subnetworkPurposes;
    return this;
  }

  /**
   * Specifies which subnetwork stack types are supported.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSubnetworkStackTypes() {
    return subnetworkStackTypes;
  }

  /**
   * Specifies which subnetwork stack types are supported.
   * @param subnetworkStackTypes subnetworkStackTypes or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setSubnetworkStackTypes(java.util.List<java.lang.String> subnetworkStackTypes) {
    this.subnetworkStackTypes = subnetworkStackTypes;
    return this;
  }

  /**
   * Specifies which type of unicast is supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getUnicast() {
    return unicast;
  }

  /**
   * Specifies which type of unicast is supported.
   * @param unicast unicast or {@code null} for none
   */
  public NetworkProfileNetworkFeatures setUnicast(java.lang.String unicast) {
    this.unicast = unicast;
    return this;
  }

  @Override
  public NetworkProfileNetworkFeatures set(String fieldName, Object value) {
    return (NetworkProfileNetworkFeatures) super.set(fieldName, value);
  }

  @Override
  public NetworkProfileNetworkFeatures clone() {
    return (NetworkProfileNetworkFeatures) super.clone();
  }

}
