/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a single Google Compute Engine preview feature.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PreviewFeature extends com.google.api.client.json.GenericJson {

  /**
   * Specifies whether the feature is enabled or disabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String activationStatus;

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * [Output Only] Description of the feature.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output only] The type of the feature. Always "compute#previewFeature" for preview features.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the feature.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Rollout operation of the feature.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PreviewFeatureRolloutOperation rolloutOperation;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output only] Status of the feature.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PreviewFeatureStatus status;

  /**
   * Specifies whether the feature is enabled or disabled.
   * @return value or {@code null} for none
   */
  public java.lang.String getActivationStatus() {
    return activationStatus;
  }

  /**
   * Specifies whether the feature is enabled or disabled.
   * @param activationStatus activationStatus or {@code null} for none
   */
  public PreviewFeature setActivationStatus(java.lang.String activationStatus) {
    this.activationStatus = activationStatus;
    return this;
  }

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public PreviewFeature setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * [Output Only] Description of the feature.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * [Output Only] Description of the feature.
   * @param description description or {@code null} for none
   */
  public PreviewFeature setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public PreviewFeature setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output only] The type of the feature. Always "compute#previewFeature" for preview features.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output only] The type of the feature. Always "compute#previewFeature" for preview features.
   * @param kind kind or {@code null} for none
   */
  public PreviewFeature setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the feature.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the feature.
   * @param name name or {@code null} for none
   */
  public PreviewFeature setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Rollout operation of the feature.
   * @return value or {@code null} for none
   */
  public PreviewFeatureRolloutOperation getRolloutOperation() {
    return rolloutOperation;
  }

  /**
   * Rollout operation of the feature.
   * @param rolloutOperation rolloutOperation or {@code null} for none
   */
  public PreviewFeature setRolloutOperation(PreviewFeatureRolloutOperation rolloutOperation) {
    this.rolloutOperation = rolloutOperation;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public PreviewFeature setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * [Output only] Status of the feature.
   * @return value or {@code null} for none
   */
  public PreviewFeatureStatus getStatus() {
    return status;
  }

  /**
   * [Output only] Status of the feature.
   * @param status status or {@code null} for none
   */
  public PreviewFeature setStatus(PreviewFeatureStatus status) {
    this.status = status;
    return this;
  }

  @Override
  public PreviewFeature set(String fieldName, Object value) {
    return (PreviewFeature) super.set(fieldName, value);
  }

  @Override
  public PreviewFeature clone() {
    return (PreviewFeature) super.clone();
  }

}
