/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for RouterStatus.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RouterStatus extends com.google.api.client.json.GenericJson {

  /**
   * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network
   * in the same region as this Cloud Router.
   *
   * Lists all of the best routes per prefix that are programmed into this region's VPC data plane.
   *
   * When global dynamic routing mode is turned on in the VPC network, this list can include cross-
   * region dynamic routes from Cloud Routers in other regions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Route> bestRoutes;

  static {
    // hack to force ProGuard to consider Route used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Route.class);
  }

  /**
   * A list of the best BGP routes learned by this Cloud Router.
   *
   * It is possible that routes listed might not be programmed into the data plane, if the Google
   * Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud
   * Router.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Route> bestRoutesForRouter;

  static {
    // hack to force ProGuard to consider Route used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Route.class);
  }

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<RouterStatusBgpPeerStatus> bgpPeerStatus;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<RouterStatusNatStatus> natStatus;

  /**
   * URI of the network to which this router belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String network;

  /**
   * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network
   * in the same region as this Cloud Router.
   *
   * Lists all of the best routes per prefix that are programmed into this region's VPC data plane.
   *
   * When global dynamic routing mode is turned on in the VPC network, this list can include cross-
   * region dynamic routes from Cloud Routers in other regions.
   * @return value or {@code null} for none
   */
  public java.util.List<Route> getBestRoutes() {
    return bestRoutes;
  }

  /**
   * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network
   * in the same region as this Cloud Router.
   *
   * Lists all of the best routes per prefix that are programmed into this region's VPC data plane.
   *
   * When global dynamic routing mode is turned on in the VPC network, this list can include cross-
   * region dynamic routes from Cloud Routers in other regions.
   * @param bestRoutes bestRoutes or {@code null} for none
   */
  public RouterStatus setBestRoutes(java.util.List<Route> bestRoutes) {
    this.bestRoutes = bestRoutes;
    return this;
  }

  /**
   * A list of the best BGP routes learned by this Cloud Router.
   *
   * It is possible that routes listed might not be programmed into the data plane, if the Google
   * Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud
   * Router.
   * @return value or {@code null} for none
   */
  public java.util.List<Route> getBestRoutesForRouter() {
    return bestRoutesForRouter;
  }

  /**
   * A list of the best BGP routes learned by this Cloud Router.
   *
   * It is possible that routes listed might not be programmed into the data plane, if the Google
   * Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud
   * Router.
   * @param bestRoutesForRouter bestRoutesForRouter or {@code null} for none
   */
  public RouterStatus setBestRoutesForRouter(java.util.List<Route> bestRoutesForRouter) {
    this.bestRoutesForRouter = bestRoutesForRouter;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.util.List<RouterStatusBgpPeerStatus> getBgpPeerStatus() {
    return bgpPeerStatus;
  }

  /**
   * @param bgpPeerStatus bgpPeerStatus or {@code null} for none
   */
  public RouterStatus setBgpPeerStatus(java.util.List<RouterStatusBgpPeerStatus> bgpPeerStatus) {
    this.bgpPeerStatus = bgpPeerStatus;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.util.List<RouterStatusNatStatus> getNatStatus() {
    return natStatus;
  }

  /**
   * @param natStatus natStatus or {@code null} for none
   */
  public RouterStatus setNatStatus(java.util.List<RouterStatusNatStatus> natStatus) {
    this.natStatus = natStatus;
    return this;
  }

  /**
   * URI of the network to which this router belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getNetwork() {
    return network;
  }

  /**
   * URI of the network to which this router belongs.
   * @param network network or {@code null} for none
   */
  public RouterStatus setNetwork(java.lang.String network) {
    this.network = network;
    return this;
  }

  @Override
  public RouterStatus set(String fieldName, Object value) {
    return (RouterStatus) super.set(fieldName, value);
  }

  @Override
  public RouterStatus clone() {
    return (RouterStatus) super.clone();
  }

}
