/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig extends com.google.api.client.json.GenericJson {

  /**
   * Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the
   * HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose
   * value is taken as the key value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String enforceOnKeyName;

  /**
   * Determines the key to enforce the rate_limit_threshold on. Possible values are:        - ALL: A
   * single rate limit threshold is applied to all    the requests matching this rule. This is the
   * default value if    "enforceOnKeyConfigs" is not configured.    - IP: The source IP address of
   * the request is the key. Each IP has this limit enforced    separately.    - HTTP_HEADER: The
   * value of the HTTP    header whose name is configured under "enforceOnKeyName". The key    value
   * is truncated to the first 128 bytes of the header value. If no    such header is present in the
   * request, the key type defaults toALL.    - XFF_IP: The first IP address (i.e. the
   * originating client IP address) specified in the list of IPs under    X-Forwarded-For HTTP
   * header. If no such header is present or the    value is not a valid IP, the key defaults to the
   * source IP address of    the request i.e. key type IP.    - HTTP_COOKIE: The value of the HTTP
   * cookie whose name is configured under "enforceOnKeyName". The key    value is truncated to the
   * first 128 bytes of the cookie value. If no    such cookie is present in the request, the key
   * type defaults toALL.    - HTTP_PATH: The URL path of the HTTP request. The key    value is
   * truncated to the first 128 bytes.     - SNI: Server name indication in the TLS session of
   * the HTTPS request. The key value is truncated to the first 128 bytes.    The key type defaults
   * to ALL on a HTTP session.     - REGION_CODE: The country/region from which the    request
   * originates.     - TLS_JA3_FINGERPRINT: JA3 TLS/SSL fingerprint if the    client connects using
   * HTTPS, HTTP/2 or HTTP/3. If not available, the    key type defaults to ALL.     - USER_IP: The
   * IP address of the originating client,    which is resolved based on "userIpRequestHeaders"
   * configured with the    security policy. If there is no "userIpRequestHeaders" configuration
   * or an IP address cannot be resolved from it, the key type defaults toIP.
   *
   * - TLS_JA4_FINGERPRINT: JA4 TLS/SSL fingerprint if the client connects using HTTPS, HTTP/2 or
   * HTTP/3. If not available, the key type defaults to ALL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String enforceOnKeyType;

  /**
   * Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the
   * HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose
   * value is taken as the key value.
   * @return value or {@code null} for none
   */
  public java.lang.String getEnforceOnKeyName() {
    return enforceOnKeyName;
  }

  /**
   * Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the
   * HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose
   * value is taken as the key value.
   * @param enforceOnKeyName enforceOnKeyName or {@code null} for none
   */
  public SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig setEnforceOnKeyName(java.lang.String enforceOnKeyName) {
    this.enforceOnKeyName = enforceOnKeyName;
    return this;
  }

  /**
   * Determines the key to enforce the rate_limit_threshold on. Possible values are:        - ALL: A
   * single rate limit threshold is applied to all    the requests matching this rule. This is the
   * default value if    "enforceOnKeyConfigs" is not configured.    - IP: The source IP address of
   * the request is the key. Each IP has this limit enforced    separately.    - HTTP_HEADER: The
   * value of the HTTP    header whose name is configured under "enforceOnKeyName". The key    value
   * is truncated to the first 128 bytes of the header value. If no    such header is present in the
   * request, the key type defaults toALL.    - XFF_IP: The first IP address (i.e. the
   * originating client IP address) specified in the list of IPs under    X-Forwarded-For HTTP
   * header. If no such header is present or the    value is not a valid IP, the key defaults to the
   * source IP address of    the request i.e. key type IP.    - HTTP_COOKIE: The value of the HTTP
   * cookie whose name is configured under "enforceOnKeyName". The key    value is truncated to the
   * first 128 bytes of the cookie value. If no    such cookie is present in the request, the key
   * type defaults toALL.    - HTTP_PATH: The URL path of the HTTP request. The key    value is
   * truncated to the first 128 bytes.     - SNI: Server name indication in the TLS session of
   * the HTTPS request. The key value is truncated to the first 128 bytes.    The key type defaults
   * to ALL on a HTTP session.     - REGION_CODE: The country/region from which the    request
   * originates.     - TLS_JA3_FINGERPRINT: JA3 TLS/SSL fingerprint if the    client connects using
   * HTTPS, HTTP/2 or HTTP/3. If not available, the    key type defaults to ALL.     - USER_IP: The
   * IP address of the originating client,    which is resolved based on "userIpRequestHeaders"
   * configured with the    security policy. If there is no "userIpRequestHeaders" configuration
   * or an IP address cannot be resolved from it, the key type defaults toIP.
   *
   * - TLS_JA4_FINGERPRINT: JA4 TLS/SSL fingerprint if the client connects using HTTPS, HTTP/2 or
   * HTTP/3. If not available, the key type defaults to ALL.
   * @return value or {@code null} for none
   */
  public java.lang.String getEnforceOnKeyType() {
    return enforceOnKeyType;
  }

  /**
   * Determines the key to enforce the rate_limit_threshold on. Possible values are:        - ALL: A
   * single rate limit threshold is applied to all    the requests matching this rule. This is the
   * default value if    "enforceOnKeyConfigs" is not configured.    - IP: The source IP address of
   * the request is the key. Each IP has this limit enforced    separately.    - HTTP_HEADER: The
   * value of the HTTP    header whose name is configured under "enforceOnKeyName". The key    value
   * is truncated to the first 128 bytes of the header value. If no    such header is present in the
   * request, the key type defaults toALL.    - XFF_IP: The first IP address (i.e. the
   * originating client IP address) specified in the list of IPs under    X-Forwarded-For HTTP
   * header. If no such header is present or the    value is not a valid IP, the key defaults to the
   * source IP address of    the request i.e. key type IP.    - HTTP_COOKIE: The value of the HTTP
   * cookie whose name is configured under "enforceOnKeyName". The key    value is truncated to the
   * first 128 bytes of the cookie value. If no    such cookie is present in the request, the key
   * type defaults toALL.    - HTTP_PATH: The URL path of the HTTP request. The key    value is
   * truncated to the first 128 bytes.     - SNI: Server name indication in the TLS session of
   * the HTTPS request. The key value is truncated to the first 128 bytes.    The key type defaults
   * to ALL on a HTTP session.     - REGION_CODE: The country/region from which the    request
   * originates.     - TLS_JA3_FINGERPRINT: JA3 TLS/SSL fingerprint if the    client connects using
   * HTTPS, HTTP/2 or HTTP/3. If not available, the    key type defaults to ALL.     - USER_IP: The
   * IP address of the originating client,    which is resolved based on "userIpRequestHeaders"
   * configured with the    security policy. If there is no "userIpRequestHeaders" configuration
   * or an IP address cannot be resolved from it, the key type defaults toIP.
   *
   * - TLS_JA4_FINGERPRINT: JA4 TLS/SSL fingerprint if the client connects using HTTPS, HTTP/2 or
   * HTTP/3. If not available, the key type defaults to ALL.
   * @param enforceOnKeyType enforceOnKeyType or {@code null} for none
   */
  public SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig setEnforceOnKeyType(java.lang.String enforceOnKeyType) {
    this.enforceOnKeyType = enforceOnKeyType;
    return this;
  }

  @Override
  public SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig set(String fieldName, Object value) {
    return (SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig) super.set(fieldName, value);
  }

  @Override
  public SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig clone() {
    return (SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig) super.clone();
  }

}
