/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for SourceDiskEncryptionKey.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SourceDiskEncryptionKey extends com.google.api.client.json.GenericJson {

  /**
   * Thecustomer-supplied encryption key of the source disk. Required if the source disk is
   * protected by a customer-supplied encryption key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CustomerEncryptionKey diskEncryptionKey;

  /**
   * URL of the disk attached to the source instance. This can be a full or valid partial URL. For
   * example, the following are valid values:              -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk     -
   * projects/project/zones/zone/disks/disk     - zones/zone/disks/disk
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceDisk;

  /**
   * Thecustomer-supplied encryption key of the source disk. Required if the source disk is
   * protected by a customer-supplied encryption key.
   * @return value or {@code null} for none
   */
  public CustomerEncryptionKey getDiskEncryptionKey() {
    return diskEncryptionKey;
  }

  /**
   * Thecustomer-supplied encryption key of the source disk. Required if the source disk is
   * protected by a customer-supplied encryption key.
   * @param diskEncryptionKey diskEncryptionKey or {@code null} for none
   */
  public SourceDiskEncryptionKey setDiskEncryptionKey(CustomerEncryptionKey diskEncryptionKey) {
    this.diskEncryptionKey = diskEncryptionKey;
    return this;
  }

  /**
   * URL of the disk attached to the source instance. This can be a full or valid partial URL. For
   * example, the following are valid values:              -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk     -
   * projects/project/zones/zone/disks/disk     - zones/zone/disks/disk
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceDisk() {
    return sourceDisk;
  }

  /**
   * URL of the disk attached to the source instance. This can be a full or valid partial URL. For
   * example, the following are valid values:              -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk     -
   * projects/project/zones/zone/disks/disk     - zones/zone/disks/disk
   * @param sourceDisk sourceDisk or {@code null} for none
   */
  public SourceDiskEncryptionKey setSourceDisk(java.lang.String sourceDisk) {
    this.sourceDisk = sourceDisk;
    return this;
  }

  @Override
  public SourceDiskEncryptionKey set(String fieldName, Object value) {
    return (SourceDiskEncryptionKey) super.set(fieldName, value);
  }

  @Override
  public SourceDiskEncryptionKey clone() {
    return (SourceDiskEncryptionKey) super.clone();
  }

}
