/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * [Output Only] Contains output only fields.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StoragePoolResourceStatus extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Number of disks used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long diskCount;

  /**
   * [Output Only] Timestamp of the last successful resize inRFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lastResizeTimestamp;

  /**
   * [Output Only] Maximum allowed aggregate disk size in GiB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxTotalProvisionedDiskCapacityGb;

  /**
   * [Output Only] Space used by data stored in disks within the storage pool (in bytes). This will
   * reflect the total number of bytes written to the disks in the pool, in contrast to the capacity
   * of those disks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long poolUsedCapacityBytes;

  /**
   * [Output Only] Sum of all the disks' provisioned IOPS, minus some amount that is allowed per
   * disk that is not counted towards pool's IOPS capacity. For more information, see
   * https://cloud.google.com/compute/docs/disks/storage-pools.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long poolUsedIops;

  /**
   * [Output Only] Sum of all the disks' provisioned throughput in MiB/s.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long poolUsedThroughput;

  /**
   * [Output Only] Amount of data written into the pool, before it is compacted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long poolUserWrittenBytes;

  /**
   * [Output Only] Sum of all the disks' provisioned capacity (in GiB) in this storage pool. A
   * disk's provisioned capacity is the same as its total capacity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long totalProvisionedDiskCapacityGb;

  /**
   * [Output Only] Sum of all the disks' provisioned IOPS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long totalProvisionedDiskIops;

  /**
   * [Output Only] Sum of all the disks' provisioned throughput in MiB/s, minus some amount that is
   * allowed per disk that is not counted towards pool's throughput capacity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long totalProvisionedDiskThroughput;

  /**
   * [Output Only] Number of disks used.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDiskCount() {
    return diskCount;
  }

  /**
   * [Output Only] Number of disks used.
   * @param diskCount diskCount or {@code null} for none
   */
  public StoragePoolResourceStatus setDiskCount(java.lang.Long diskCount) {
    this.diskCount = diskCount;
    return this;
  }

  /**
   * [Output Only] Timestamp of the last successful resize inRFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getLastResizeTimestamp() {
    return lastResizeTimestamp;
  }

  /**
   * [Output Only] Timestamp of the last successful resize inRFC3339 text format.
   * @param lastResizeTimestamp lastResizeTimestamp or {@code null} for none
   */
  public StoragePoolResourceStatus setLastResizeTimestamp(java.lang.String lastResizeTimestamp) {
    this.lastResizeTimestamp = lastResizeTimestamp;
    return this;
  }

  /**
   * [Output Only] Maximum allowed aggregate disk size in GiB.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxTotalProvisionedDiskCapacityGb() {
    return maxTotalProvisionedDiskCapacityGb;
  }

  /**
   * [Output Only] Maximum allowed aggregate disk size in GiB.
   * @param maxTotalProvisionedDiskCapacityGb maxTotalProvisionedDiskCapacityGb or {@code null} for none
   */
  public StoragePoolResourceStatus setMaxTotalProvisionedDiskCapacityGb(java.lang.Long maxTotalProvisionedDiskCapacityGb) {
    this.maxTotalProvisionedDiskCapacityGb = maxTotalProvisionedDiskCapacityGb;
    return this;
  }

  /**
   * [Output Only] Space used by data stored in disks within the storage pool (in bytes). This will
   * reflect the total number of bytes written to the disks in the pool, in contrast to the capacity
   * of those disks.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPoolUsedCapacityBytes() {
    return poolUsedCapacityBytes;
  }

  /**
   * [Output Only] Space used by data stored in disks within the storage pool (in bytes). This will
   * reflect the total number of bytes written to the disks in the pool, in contrast to the capacity
   * of those disks.
   * @param poolUsedCapacityBytes poolUsedCapacityBytes or {@code null} for none
   */
  public StoragePoolResourceStatus setPoolUsedCapacityBytes(java.lang.Long poolUsedCapacityBytes) {
    this.poolUsedCapacityBytes = poolUsedCapacityBytes;
    return this;
  }

  /**
   * [Output Only] Sum of all the disks' provisioned IOPS, minus some amount that is allowed per
   * disk that is not counted towards pool's IOPS capacity. For more information, see
   * https://cloud.google.com/compute/docs/disks/storage-pools.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPoolUsedIops() {
    return poolUsedIops;
  }

  /**
   * [Output Only] Sum of all the disks' provisioned IOPS, minus some amount that is allowed per
   * disk that is not counted towards pool's IOPS capacity. For more information, see
   * https://cloud.google.com/compute/docs/disks/storage-pools.
   * @param poolUsedIops poolUsedIops or {@code null} for none
   */
  public StoragePoolResourceStatus setPoolUsedIops(java.lang.Long poolUsedIops) {
    this.poolUsedIops = poolUsedIops;
    return this;
  }

  /**
   * [Output Only] Sum of all the disks' provisioned throughput in MiB/s.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPoolUsedThroughput() {
    return poolUsedThroughput;
  }

  /**
   * [Output Only] Sum of all the disks' provisioned throughput in MiB/s.
   * @param poolUsedThroughput poolUsedThroughput or {@code null} for none
   */
  public StoragePoolResourceStatus setPoolUsedThroughput(java.lang.Long poolUsedThroughput) {
    this.poolUsedThroughput = poolUsedThroughput;
    return this;
  }

  /**
   * [Output Only] Amount of data written into the pool, before it is compacted.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPoolUserWrittenBytes() {
    return poolUserWrittenBytes;
  }

  /**
   * [Output Only] Amount of data written into the pool, before it is compacted.
   * @param poolUserWrittenBytes poolUserWrittenBytes or {@code null} for none
   */
  public StoragePoolResourceStatus setPoolUserWrittenBytes(java.lang.Long poolUserWrittenBytes) {
    this.poolUserWrittenBytes = poolUserWrittenBytes;
    return this;
  }

  /**
   * [Output Only] Sum of all the disks' provisioned capacity (in GiB) in this storage pool. A
   * disk's provisioned capacity is the same as its total capacity.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTotalProvisionedDiskCapacityGb() {
    return totalProvisionedDiskCapacityGb;
  }

  /**
   * [Output Only] Sum of all the disks' provisioned capacity (in GiB) in this storage pool. A
   * disk's provisioned capacity is the same as its total capacity.
   * @param totalProvisionedDiskCapacityGb totalProvisionedDiskCapacityGb or {@code null} for none
   */
  public StoragePoolResourceStatus setTotalProvisionedDiskCapacityGb(java.lang.Long totalProvisionedDiskCapacityGb) {
    this.totalProvisionedDiskCapacityGb = totalProvisionedDiskCapacityGb;
    return this;
  }

  /**
   * [Output Only] Sum of all the disks' provisioned IOPS.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTotalProvisionedDiskIops() {
    return totalProvisionedDiskIops;
  }

  /**
   * [Output Only] Sum of all the disks' provisioned IOPS.
   * @param totalProvisionedDiskIops totalProvisionedDiskIops or {@code null} for none
   */
  public StoragePoolResourceStatus setTotalProvisionedDiskIops(java.lang.Long totalProvisionedDiskIops) {
    this.totalProvisionedDiskIops = totalProvisionedDiskIops;
    return this;
  }

  /**
   * [Output Only] Sum of all the disks' provisioned throughput in MiB/s, minus some amount that is
   * allowed per disk that is not counted towards pool's throughput capacity.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTotalProvisionedDiskThroughput() {
    return totalProvisionedDiskThroughput;
  }

  /**
   * [Output Only] Sum of all the disks' provisioned throughput in MiB/s, minus some amount that is
   * allowed per disk that is not counted towards pool's throughput capacity.
   * @param totalProvisionedDiskThroughput totalProvisionedDiskThroughput or {@code null} for none
   */
  public StoragePoolResourceStatus setTotalProvisionedDiskThroughput(java.lang.Long totalProvisionedDiskThroughput) {
    this.totalProvisionedDiskThroughput = totalProvisionedDiskThroughput;
    return this;
  }

  @Override
  public StoragePoolResourceStatus set(String fieldName, Object value) {
    return (StoragePoolResourceStatus) super.set(fieldName, value);
  }

  @Override
  public StoragePoolResourceStatus clone() {
    return (StoragePoolResourceStatus) super.clone();
  }

}
