/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The IPV4 utilization of a single IP range.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SubnetworkUtilizationDetailsIPV4Utilization extends com.google.api.client.json.GenericJson {

  /**
   * Will be set for secondary range. Empty for primary IPv4 range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rangeName;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long totalAllocatedIp;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long totalFreeIp;

  /**
   * Will be set for secondary range. Empty for primary IPv4 range.
   * @return value or {@code null} for none
   */
  public java.lang.String getRangeName() {
    return rangeName;
  }

  /**
   * Will be set for secondary range. Empty for primary IPv4 range.
   * @param rangeName rangeName or {@code null} for none
   */
  public SubnetworkUtilizationDetailsIPV4Utilization setRangeName(java.lang.String rangeName) {
    this.rangeName = rangeName;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.Long getTotalAllocatedIp() {
    return totalAllocatedIp;
  }

  /**
   * @param totalAllocatedIp totalAllocatedIp or {@code null} for none
   */
  public SubnetworkUtilizationDetailsIPV4Utilization setTotalAllocatedIp(java.lang.Long totalAllocatedIp) {
    this.totalAllocatedIp = totalAllocatedIp;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.Long getTotalFreeIp() {
    return totalFreeIp;
  }

  /**
   * @param totalFreeIp totalFreeIp or {@code null} for none
   */
  public SubnetworkUtilizationDetailsIPV4Utilization setTotalFreeIp(java.lang.Long totalFreeIp) {
    this.totalFreeIp = totalFreeIp;
    return this;
  }

  @Override
  public SubnetworkUtilizationDetailsIPV4Utilization set(String fieldName, Object value) {
    return (SubnetworkUtilizationDetailsIPV4Utilization) super.set(fieldName, value);
  }

  @Override
  public SubnetworkUtilizationDetailsIPV4Utilization clone() {
    return (SubnetworkUtilizationDetailsIPV4Utilization) super.clone();
  }

}
