/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The IPV6 utilization of a single IP range.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SubnetworkUtilizationDetailsIPV6Utilization extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Uint128 totalAllocatedIp;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Uint128 totalFreeIp;

  /**
   * @return value or {@code null} for none
   */
  public Uint128 getTotalAllocatedIp() {
    return totalAllocatedIp;
  }

  /**
   * @param totalAllocatedIp totalAllocatedIp or {@code null} for none
   */
  public SubnetworkUtilizationDetailsIPV6Utilization setTotalAllocatedIp(Uint128 totalAllocatedIp) {
    this.totalAllocatedIp = totalAllocatedIp;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public Uint128 getTotalFreeIp() {
    return totalFreeIp;
  }

  /**
   * @param totalFreeIp totalFreeIp or {@code null} for none
   */
  public SubnetworkUtilizationDetailsIPV6Utilization setTotalFreeIp(Uint128 totalFreeIp) {
    this.totalFreeIp = totalFreeIp;
    return this;
  }

  @Override
  public SubnetworkUtilizationDetailsIPV6Utilization set(String fieldName, Object value) {
    return (SubnetworkUtilizationDetailsIPV6Utilization) super.set(fieldName, value);
  }

  @Override
  public SubnetworkUtilizationDetailsIPV6Utilization clone() {
    return (SubnetworkUtilizationDetailsIPV6Utilization) super.clone();
  }

}
