/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Message for the expected URL mappings.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UrlMapTest extends com.google.api.client.json.GenericJson {

  /**
   * Description of this test case.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The expected output URL evaluated by the load balancer containing the scheme, host, path and
   * query parameters.
   *
   * For rules that forward requests to backends, the test passes only whenexpectedOutputUrl matches
   * the request forwarded by the load balancer to backends. For rules with urlRewrite, the test
   * verifies that the forwarded request matcheshostRewrite and pathPrefixRewrite in theurlRewrite
   * action. When service is specified,expectedOutputUrl`s scheme is ignored.
   *
   * For rules with urlRedirect, the test passes only ifexpectedOutputUrl matches the URL in the
   * load balancer's redirect response. If urlRedirect specifieshttps_redirect, the test passes only
   * if the scheme inexpectedOutputUrl is also set to HTTPS. If urlRedirect specifies strip_query,
   * the test passes only if expectedOutputUrl does not contain any query parameters.
   *
   * expectedOutputUrl is optional whenservice is specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String expectedOutputUrl;

  /**
   * For rules with urlRedirect, the test passes only ifexpectedRedirectResponseCode matches the
   * HTTP status code in load balancer's redirect response.
   *
   * expectedRedirectResponseCode cannot be set whenservice is set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer expectedRedirectResponseCode;

  /**
   * HTTP headers for this request. If headers contains a host header, then host must also match the
   * header value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<UrlMapTestHeader> headers;

  /**
   * Host portion of the URL. If headers contains a host header, then host must also match the
   * header value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String host;

  /**
   * Path portion of the URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String path;

  /**
   * Expected BackendService or BackendBucket resource the given URL should be mapped to.
   *
   * The service field cannot be set if expectedRedirectResponseCode is set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String service;

  /**
   * Description of this test case.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Description of this test case.
   * @param description description or {@code null} for none
   */
  public UrlMapTest setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The expected output URL evaluated by the load balancer containing the scheme, host, path and
   * query parameters.
   *
   * For rules that forward requests to backends, the test passes only whenexpectedOutputUrl matches
   * the request forwarded by the load balancer to backends. For rules with urlRewrite, the test
   * verifies that the forwarded request matcheshostRewrite and pathPrefixRewrite in theurlRewrite
   * action. When service is specified,expectedOutputUrl`s scheme is ignored.
   *
   * For rules with urlRedirect, the test passes only ifexpectedOutputUrl matches the URL in the
   * load balancer's redirect response. If urlRedirect specifieshttps_redirect, the test passes only
   * if the scheme inexpectedOutputUrl is also set to HTTPS. If urlRedirect specifies strip_query,
   * the test passes only if expectedOutputUrl does not contain any query parameters.
   *
   * expectedOutputUrl is optional whenservice is specified.
   * @return value or {@code null} for none
   */
  public java.lang.String getExpectedOutputUrl() {
    return expectedOutputUrl;
  }

  /**
   * The expected output URL evaluated by the load balancer containing the scheme, host, path and
   * query parameters.
   *
   * For rules that forward requests to backends, the test passes only whenexpectedOutputUrl matches
   * the request forwarded by the load balancer to backends. For rules with urlRewrite, the test
   * verifies that the forwarded request matcheshostRewrite and pathPrefixRewrite in theurlRewrite
   * action. When service is specified,expectedOutputUrl`s scheme is ignored.
   *
   * For rules with urlRedirect, the test passes only ifexpectedOutputUrl matches the URL in the
   * load balancer's redirect response. If urlRedirect specifieshttps_redirect, the test passes only
   * if the scheme inexpectedOutputUrl is also set to HTTPS. If urlRedirect specifies strip_query,
   * the test passes only if expectedOutputUrl does not contain any query parameters.
   *
   * expectedOutputUrl is optional whenservice is specified.
   * @param expectedOutputUrl expectedOutputUrl or {@code null} for none
   */
  public UrlMapTest setExpectedOutputUrl(java.lang.String expectedOutputUrl) {
    this.expectedOutputUrl = expectedOutputUrl;
    return this;
  }

  /**
   * For rules with urlRedirect, the test passes only ifexpectedRedirectResponseCode matches the
   * HTTP status code in load balancer's redirect response.
   *
   * expectedRedirectResponseCode cannot be set whenservice is set.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getExpectedRedirectResponseCode() {
    return expectedRedirectResponseCode;
  }

  /**
   * For rules with urlRedirect, the test passes only ifexpectedRedirectResponseCode matches the
   * HTTP status code in load balancer's redirect response.
   *
   * expectedRedirectResponseCode cannot be set whenservice is set.
   * @param expectedRedirectResponseCode expectedRedirectResponseCode or {@code null} for none
   */
  public UrlMapTest setExpectedRedirectResponseCode(java.lang.Integer expectedRedirectResponseCode) {
    this.expectedRedirectResponseCode = expectedRedirectResponseCode;
    return this;
  }

  /**
   * HTTP headers for this request. If headers contains a host header, then host must also match the
   * header value.
   * @return value or {@code null} for none
   */
  public java.util.List<UrlMapTestHeader> getHeaders() {
    return headers;
  }

  /**
   * HTTP headers for this request. If headers contains a host header, then host must also match the
   * header value.
   * @param headers headers or {@code null} for none
   */
  public UrlMapTest setHeaders(java.util.List<UrlMapTestHeader> headers) {
    this.headers = headers;
    return this;
  }

  /**
   * Host portion of the URL. If headers contains a host header, then host must also match the
   * header value.
   * @return value or {@code null} for none
   */
  public java.lang.String getHost() {
    return host;
  }

  /**
   * Host portion of the URL. If headers contains a host header, then host must also match the
   * header value.
   * @param host host or {@code null} for none
   */
  public UrlMapTest setHost(java.lang.String host) {
    this.host = host;
    return this;
  }

  /**
   * Path portion of the URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getPath() {
    return path;
  }

  /**
   * Path portion of the URL.
   * @param path path or {@code null} for none
   */
  public UrlMapTest setPath(java.lang.String path) {
    this.path = path;
    return this;
  }

  /**
   * Expected BackendService or BackendBucket resource the given URL should be mapped to.
   *
   * The service field cannot be set if expectedRedirectResponseCode is set.
   * @return value or {@code null} for none
   */
  public java.lang.String getService() {
    return service;
  }

  /**
   * Expected BackendService or BackendBucket resource the given URL should be mapped to.
   *
   * The service field cannot be set if expectedRedirectResponseCode is set.
   * @param service service or {@code null} for none
   */
  public UrlMapTest setService(java.lang.String service) {
    this.service = service;
    return this;
  }

  @Override
  public UrlMapTest set(String fieldName, Object value) {
    return (UrlMapTest) super.set(fieldName, value);
  }

  @Override
  public UrlMapTest clone() {
    return (UrlMapTest) super.clone();
  }

}
